/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class ConnectionTestExecutable {
    public static void main(String[] args) throws IOException {
        String input = new String(System.in.readAllBytes(), StandardCharsets.UTF_8);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(input);
        String payload = new String(Base64.getDecoder().decode(jsonNode.get("input").asText()));
        System.out.println("Hello " + payload);
        System.out.println("Testing connection: ");
        ConnectionTestExecutable.testConnection("example.com", 80);
        ConnectionTestExecutable.testConnection("example.com", 443);
        ConnectionTestExecutable.testConnection("securosys.com", 80);
        System.out.println("Testing example.com:80: " + ConnectionTestExecutable.canConnect("example.com", 80));
        System.out.println("Testing example.com:443: " + ConnectionTestExecutable.canConnect("example.com", 443));
        System.out.println("Testing securosys.com:80: " + ConnectionTestExecutable.canConnect("securosys.com", 80));
    }

    private static void testConnection(String host, int port) {
        if (ConnectionTestExecutable.canConnect(host, port)) {
            System.out.println("Connection successful to " + host + " on port " + port);
        } else {
            System.out.println("Failed to connect to " + host + " on port " + port);
        }
    }

    private static boolean canConnect(String host, int port) {
        boolean bl;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(host, port), 3000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }
}

