/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.db;

import com.securosys.tee.db.DatabaseAdapter;
import com.securosys.tee.db.DatabaseDialect;
import com.securosys.tee.db.H2DialectAdapter;
import com.securosys.tee.db.MariaDbDialectAdapter;
import com.securosys.tee.db.PostgresDialectAdapter;
import com.securosys.tee.dto.JvmInput;

public class DatabaseFactory {
    public static DatabaseAdapter create(JvmInput input) {
        if (input.getDatabase() == null) {
            throw new UnsupportedOperationException("JvmInput does not contains database connection.");
        }
        DatabaseDialect databaseDialect = DatabaseDialect.fromUrl(input.getDatabase().getUrl());
        switch (databaseDialect) {
            case POSTGRESQL: {
                return new PostgresDialectAdapter(input.getDatabase(), input.getMasterDatabase());
            }
            case MARIADB: {
                return new MariaDbDialectAdapter(input.getDatabase());
            }
            case H2: {
                return new H2DialectAdapter(input.getDatabase());
            }
        }
        throw new UnsupportedOperationException("Unsupported database dialect");
    }

    public static void loadDriver(JvmInput input) {
        if (input.getDatabase() == null) {
            throw new UnsupportedOperationException("JvmInput does not contains database connection.");
        }
        DatabaseDialect dialect = DatabaseDialect.fromUrl(input.getDatabase().getUrl());
        String driverClassName = DatabaseFactory.getDriverClassName(dialect);
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("JDBC Driver not found for: " + dialect, e);
        }
    }

    private static String getDriverClassName(DatabaseDialect dialect) {
        switch (dialect) {
            case POSTGRESQL: {
                return "org.postgresql.Driver";
            }
            case MARIADB: {
                return "org.mariadb.jdbc.Driver";
            }
            case H2: {
                return "org.h2.Driver";
            }
        }
        return null;
    }
}

