/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

@Schema(description="Creating an approver key-pair, based on approver name (key-name) and backup password.")
public class ApproverCreateDto {
    @NotEmpty
    @NotNull
    @Schema(description="The name of the approver e.g. the e-mail address")
    private String approverName;
    @Schema(description="The algorithm with which the key should be created.", example="RSA", allowableValues={"RSA"})
    @NotNull
    @NotEmpty
    private String algorithm;
    @JacksonXmlProperty(localName="key_size")
    @Schema(description="The length of the key. Only applicable for RSA.", example="2048")
    private Integer keySize;
    @NotEmpty
    @NotNull
    @ArraySchema(arraySchema=@Schema(description="The password of the P12 container, used for backup and restore"), schema=@Schema(pattern="^.{1}$"))
    private char[] backupPassword;
    @Schema(description="The days from today after which the certificate is not valid. e.g. 3650 //valid for 10 years.", example="3650")
    private Integer validity;

    public String getApproverName() {
        return this.approverName;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public char[] getBackupPassword() {
        return this.backupPassword;
    }

    public Integer getValidity() {
        return this.validity;
    }

    public void setApproverName(String approverName) {
        this.approverName = approverName;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @JacksonXmlProperty(localName="key_size")
    public void setKeySize(Integer keySize) {
        this.keySize = keySize;
    }

    public void setBackupPassword(char[] backupPassword) {
        this.backupPassword = backupPassword;
    }

    public void setValidity(Integer validity) {
        this.validity = validity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApproverCreateDto)) {
            return false;
        }
        ApproverCreateDto other = (ApproverCreateDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$keySize = this.getKeySize();
        Integer other$keySize = other.getKeySize();
        if (this$keySize == null ? other$keySize != null : !((Object)this$keySize).equals(other$keySize)) {
            return false;
        }
        Integer this$validity = this.getValidity();
        Integer other$validity = other.getValidity();
        if (this$validity == null ? other$validity != null : !((Object)this$validity).equals(other$validity)) {
            return false;
        }
        String this$approverName = this.getApproverName();
        String other$approverName = other.getApproverName();
        if (this$approverName == null ? other$approverName != null : !this$approverName.equals(other$approverName)) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        return Arrays.equals(this.getBackupPassword(), other.getBackupPassword());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApproverCreateDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $keySize = this.getKeySize();
        result = result * 59 + ($keySize == null ? 43 : ((Object)$keySize).hashCode());
        Integer $validity = this.getValidity();
        result = result * 59 + ($validity == null ? 43 : ((Object)$validity).hashCode());
        String $approverName = this.getApproverName();
        result = result * 59 + ($approverName == null ? 43 : $approverName.hashCode());
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBackupPassword());
        return result;
    }

    public String toString() {
        return "ApproverCreateDto(approverName=" + this.getApproverName() + ", algorithm=" + this.getAlgorithm() + ", keySize=" + this.getKeySize() + ", backupPassword=" + Arrays.toString(this.getBackupPassword()) + ", validity=" + this.getValidity() + ")";
    }
}

