/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.securosys.tee.dto.tsb.PolicyDto;
import com.securosys.tee.dto.tsb.request.AddressFormatDto;
import com.securosys.tee.dto.tsb.request.AttributesDto;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

@JacksonXmlRootElement(localName="private_key")
@Schema(description="Create key request.")
public class CreateKeyDto {
    @NotEmpty
    @Schema(description="The name of the key.")
    private String label;
    @ArraySchema(arraySchema=@Schema(description="The password of the key"), schema=@Schema(pattern="^.{1}$"))
    private char[] password;
    @Schema(description="The id of the key, used if working with keys generated on TSB and used with PKCS#11 provider")
    private String id;
    @Schema(description="The algorithm with which the key should be created. Either the algorithm or the algorithm_oid must be set.", example="EC", allowableValues={"EC", "ED", "RSA", "DSA", "ISS", "BLS", "AES", "ChaCha20", "Camellia", "TDEA", "DILITHIUM_L2", "DILITHIUM_L3", "DILITHIUM_L5", "SPHINCS_PLUS_SHAKE_L1", "SPHINCS_PLUS_SHAKE_L3", "SPHINCS_PLUS_SHAKE_L5", "KYBER512_WITH_SHAKE", "KYBER768_WITH_SHAKE", "KYBER1024_WITH_SHAKE", "KYBER512_WITH_SHA2_AES", "KYBER768_WITH_SHA2_AES", "KYBER1024_WITH_SHA2_AES"})
    private String algorithm;
    @JacksonXmlProperty(localName="algorithm_oid")
    @Schema(description="The oid of the algorithm with which the key should be created. Either the algorithm or the algorithm_oid must be set.", example="1.2.840.10045.2.1")
    private String algorithmOid;
    @JacksonXmlProperty(localName="curve_oid")
    @Schema(description="The oid of the curve used for the EC or ED algorithm. Mandatory if chosen algorithm is set to EC or ED. secp224k1: 1.3.132.0.32\nsecp224r1: 1.3.132.0.33\nsecp256k1: 1.3.132.0.10\nsecp256r1 (also known as P-256 or prime256v1): 1.2.840.10045.3.1.7\nsecp384r1 (also known as P-384): 1.3.132.0.34\nsecp521r1 (also known as P-521): 1.3.132.0.35\nx962p239v1: 1.2.840.10045.3.1.1\nx962p239v2: 1.2.840.10045.3.1.2\nx962p239v3: 1.2.840.10045.3.1.3\nbrainpool224r1: 1.3.36.3.3.2.8.1.1.1\nbrainpool256r1: 1.3.36.3.3.2.8.1.1.7\nbrainpool320r1: 1.3.36.3.3.2.8.1.1.9\nbrainpool384r1: 1.3.36.3.3.2.8.1.1.11\nbrainpool512r1: 1.3.36.3.3.2.8.1.1.13\nfrp256v1: 1.2.250.1.223.101.256.1\nEd25519: 1.3.101.112", example="1.3.132.0.10")
    private String curveOid;
    @JacksonXmlProperty(localName="key_size")
    @Schema(description="The length of the key. Only applicable for RSA , DSA and ISS. For ISS this attribute sets the security level (1, 2 or 3).")
    private Integer keySize;
    @JacksonXmlProperty(localName="address_truncated")
    private AddressFormatDto addressFormat;
    @NotNull
    @Valid
    private AttributesDto attributes;
    @Valid
    private PolicyDto policy;

    public String getLabel() {
        return this.label;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getId() {
        return this.id;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getAlgorithmOid() {
        return this.algorithmOid;
    }

    public String getCurveOid() {
        return this.curveOid;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public AddressFormatDto getAddressFormat() {
        return this.addressFormat;
    }

    public AttributesDto getAttributes() {
        return this.attributes;
    }

    public PolicyDto getPolicy() {
        return this.policy;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @JacksonXmlProperty(localName="algorithm_oid")
    public void setAlgorithmOid(String algorithmOid) {
        this.algorithmOid = algorithmOid;
    }

    @JacksonXmlProperty(localName="curve_oid")
    public void setCurveOid(String curveOid) {
        this.curveOid = curveOid;
    }

    @JacksonXmlProperty(localName="key_size")
    public void setKeySize(Integer keySize) {
        this.keySize = keySize;
    }

    @JacksonXmlProperty(localName="address_truncated")
    public void setAddressFormat(AddressFormatDto addressFormat) {
        this.addressFormat = addressFormat;
    }

    public void setAttributes(AttributesDto attributes) {
        this.attributes = attributes;
    }

    public void setPolicy(PolicyDto policy) {
        this.policy = policy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateKeyDto)) {
            return false;
        }
        CreateKeyDto other = (CreateKeyDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$keySize = this.getKeySize();
        Integer other$keySize = other.getKeySize();
        if (this$keySize == null ? other$keySize != null : !((Object)this$keySize).equals(other$keySize)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        String this$algorithmOid = this.getAlgorithmOid();
        String other$algorithmOid = other.getAlgorithmOid();
        if (this$algorithmOid == null ? other$algorithmOid != null : !this$algorithmOid.equals(other$algorithmOid)) {
            return false;
        }
        String this$curveOid = this.getCurveOid();
        String other$curveOid = other.getCurveOid();
        if (this$curveOid == null ? other$curveOid != null : !this$curveOid.equals(other$curveOid)) {
            return false;
        }
        AddressFormatDto this$addressFormat = this.getAddressFormat();
        AddressFormatDto other$addressFormat = other.getAddressFormat();
        if (this$addressFormat == null ? other$addressFormat != null : !((Object)this$addressFormat).equals(other$addressFormat)) {
            return false;
        }
        AttributesDto this$attributes = this.getAttributes();
        AttributesDto other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        PolicyDto this$policy = this.getPolicy();
        PolicyDto other$policy = other.getPolicy();
        return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateKeyDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $keySize = this.getKeySize();
        result = result * 59 + ($keySize == null ? 43 : ((Object)$keySize).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        String $algorithmOid = this.getAlgorithmOid();
        result = result * 59 + ($algorithmOid == null ? 43 : $algorithmOid.hashCode());
        String $curveOid = this.getCurveOid();
        result = result * 59 + ($curveOid == null ? 43 : $curveOid.hashCode());
        AddressFormatDto $addressFormat = this.getAddressFormat();
        result = result * 59 + ($addressFormat == null ? 43 : ((Object)$addressFormat).hashCode());
        AttributesDto $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        PolicyDto $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        return result;
    }

    public String toString() {
        return "CreateKeyDto(label=" + this.getLabel() + ", password=" + Arrays.toString(this.getPassword()) + ", id=" + this.getId() + ", algorithm=" + this.getAlgorithm() + ", algorithmOid=" + this.getAlgorithmOid() + ", curveOid=" + this.getCurveOid() + ", keySize=" + this.getKeySize() + ", addressFormat=" + this.getAddressFormat() + ", attributes=" + this.getAttributes() + ", policy=" + this.getPolicy() + ")";
    }
}

