/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.dto.tsb.ModifyPolicyDto;
import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

@Schema(description="Modify key request")
public class ModifyKeyRequestDto {
    @NotEmpty
    @Schema(description="Name of the key which shall be modified.")
    private String modifyKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the modify key."), schema=@Schema(pattern="^.{1}$"))
    private char[] keyPassword;
    @Base64Encoded
    @Schema(description="Additional meta data that will be provided to the approval client.", format="base64")
    private String metaData;
    @Base64Encoded
    @Schema(description="Signature for the meta data.", format="base64")
    private String metaDataSignature;
    @NotNull
    private ModifyPolicyDto policy;

    public String getModifyKeyName() {
        return this.modifyKeyName;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String getMetaDataSignature() {
        return this.metaDataSignature;
    }

    public ModifyPolicyDto getPolicy() {
        return this.policy;
    }

    public void setModifyKeyName(String modifyKeyName) {
        this.modifyKeyName = modifyKeyName;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    public void setMetaDataSignature(String metaDataSignature) {
        this.metaDataSignature = metaDataSignature;
    }

    public void setPolicy(ModifyPolicyDto policy) {
        this.policy = policy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifyKeyRequestDto)) {
            return false;
        }
        ModifyKeyRequestDto other = (ModifyKeyRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$modifyKeyName = this.getModifyKeyName();
        String other$modifyKeyName = other.getModifyKeyName();
        if (this$modifyKeyName == null ? other$modifyKeyName != null : !this$modifyKeyName.equals(other$modifyKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyPassword(), other.getKeyPassword())) {
            return false;
        }
        String this$metaData = this.getMetaData();
        String other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData)) {
            return false;
        }
        String this$metaDataSignature = this.getMetaDataSignature();
        String other$metaDataSignature = other.getMetaDataSignature();
        if (this$metaDataSignature == null ? other$metaDataSignature != null : !this$metaDataSignature.equals(other$metaDataSignature)) {
            return false;
        }
        ModifyPolicyDto this$policy = this.getPolicy();
        ModifyPolicyDto other$policy = other.getPolicy();
        return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifyKeyRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $modifyKeyName = this.getModifyKeyName();
        result = result * 59 + ($modifyKeyName == null ? 43 : $modifyKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        String $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
        String $metaDataSignature = this.getMetaDataSignature();
        result = result * 59 + ($metaDataSignature == null ? 43 : $metaDataSignature.hashCode());
        ModifyPolicyDto $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        return result;
    }

    public String toString() {
        return "ModifyKeyRequestDto(modifyKeyName=" + this.getModifyKeyName() + ", keyPassword=" + Arrays.toString(this.getKeyPassword()) + ", metaData=" + this.getMetaData() + ", metaDataSignature=" + this.getMetaDataSignature() + ", policy=" + this.getPolicy() + ")";
    }
}

