/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.dto.tsb.request.CertificateAttributesDto;
import com.securosys.tee.enums.tsb.ExtendedKeyUsage;
import com.securosys.tee.enums.tsb.KeyUsage;
import com.securosys.tee.enums.tsb.KeytoolSignatureAlgorithm;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;

@Schema(description="Create a certificate request.")
public class SynchronousCertificateRequestRequestDto {
    @NotEmpty
    @Schema(description="The name of the key used to sign the certificate request.")
    private String signKeyName;
    @ArraySchema(arraySchema=@Schema(description="The password of the key"), schema=@Schema(pattern="^.{1}$"))
    private char[] keyPassword;
    @NotNull
    @Schema(description="The signature algorithm to be used. The chosen algorithm has to be compatible with the type of the key referenced by the signKeyName.")
    private KeytoolSignatureAlgorithm signatureAlgorithm;
    @NotNull
    @Schema(description="The days from today after which the certificate is not valid. e.g. 365 //valid for 1 year.")
    private int validity;
    @NotNull
    @Schema(description="The standard certificate request attributes for X.500 series")
    private CertificateAttributesDto standardCertificateAttributes;
    @Schema(description="The key usage extension defines the purpose (for example, encipherment, signature, or certificate signing) of the key contained in the certificate. If the public key is used for entity authentication, then the certificate extension should have the key usage Digital signature.")
    private List<KeyUsage> keyUsage;
    @Schema(description="This extension indicates one or more purposes for which the certified public key may be used, in addition to or in place of the basic purposes indicated in the key usage extension. In general, this extension will appear only in end entity certificates.")
    private List<ExtendedKeyUsage> extendedKeyUsage;

    public String getSignKeyName() {
        return this.signKeyName;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public KeytoolSignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public int getValidity() {
        return this.validity;
    }

    public CertificateAttributesDto getStandardCertificateAttributes() {
        return this.standardCertificateAttributes;
    }

    public List<KeyUsage> getKeyUsage() {
        return this.keyUsage;
    }

    public List<ExtendedKeyUsage> getExtendedKeyUsage() {
        return this.extendedKeyUsage;
    }

    public void setSignKeyName(String signKeyName) {
        this.signKeyName = signKeyName;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setSignatureAlgorithm(KeytoolSignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public void setValidity(int validity) {
        this.validity = validity;
    }

    public void setStandardCertificateAttributes(CertificateAttributesDto standardCertificateAttributes) {
        this.standardCertificateAttributes = standardCertificateAttributes;
    }

    public void setKeyUsage(List<KeyUsage> keyUsage) {
        this.keyUsage = keyUsage;
    }

    public void setExtendedKeyUsage(List<ExtendedKeyUsage> extendedKeyUsage) {
        this.extendedKeyUsage = extendedKeyUsage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronousCertificateRequestRequestDto)) {
            return false;
        }
        SynchronousCertificateRequestRequestDto other = (SynchronousCertificateRequestRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getValidity() != other.getValidity()) {
            return false;
        }
        String this$signKeyName = this.getSignKeyName();
        String other$signKeyName = other.getSignKeyName();
        if (this$signKeyName == null ? other$signKeyName != null : !this$signKeyName.equals(other$signKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyPassword(), other.getKeyPassword())) {
            return false;
        }
        KeytoolSignatureAlgorithm this$signatureAlgorithm = this.getSignatureAlgorithm();
        KeytoolSignatureAlgorithm other$signatureAlgorithm = other.getSignatureAlgorithm();
        if (this$signatureAlgorithm == null ? other$signatureAlgorithm != null : !((Object)((Object)this$signatureAlgorithm)).equals((Object)other$signatureAlgorithm)) {
            return false;
        }
        CertificateAttributesDto this$standardCertificateAttributes = this.getStandardCertificateAttributes();
        CertificateAttributesDto other$standardCertificateAttributes = other.getStandardCertificateAttributes();
        if (this$standardCertificateAttributes == null ? other$standardCertificateAttributes != null : !((Object)this$standardCertificateAttributes).equals(other$standardCertificateAttributes)) {
            return false;
        }
        List<KeyUsage> this$keyUsage = this.getKeyUsage();
        List<KeyUsage> other$keyUsage = other.getKeyUsage();
        if (this$keyUsage == null ? other$keyUsage != null : !((Object)this$keyUsage).equals(other$keyUsage)) {
            return false;
        }
        List<ExtendedKeyUsage> this$extendedKeyUsage = this.getExtendedKeyUsage();
        List<ExtendedKeyUsage> other$extendedKeyUsage = other.getExtendedKeyUsage();
        return !(this$extendedKeyUsage == null ? other$extendedKeyUsage != null : !((Object)this$extendedKeyUsage).equals(other$extendedKeyUsage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SynchronousCertificateRequestRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getValidity();
        String $signKeyName = this.getSignKeyName();
        result = result * 59 + ($signKeyName == null ? 43 : $signKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        KeytoolSignatureAlgorithm $signatureAlgorithm = this.getSignatureAlgorithm();
        result = result * 59 + ($signatureAlgorithm == null ? 43 : ((Object)((Object)$signatureAlgorithm)).hashCode());
        CertificateAttributesDto $standardCertificateAttributes = this.getStandardCertificateAttributes();
        result = result * 59 + ($standardCertificateAttributes == null ? 43 : ((Object)$standardCertificateAttributes).hashCode());
        List<KeyUsage> $keyUsage = this.getKeyUsage();
        result = result * 59 + ($keyUsage == null ? 43 : ((Object)$keyUsage).hashCode());
        List<ExtendedKeyUsage> $extendedKeyUsage = this.getExtendedKeyUsage();
        result = result * 59 + ($extendedKeyUsage == null ? 43 : ((Object)$extendedKeyUsage).hashCode());
        return result;
    }

    public String toString() {
        return "SynchronousCertificateRequestRequestDto(signKeyName=" + this.getSignKeyName() + ", keyPassword=" + Arrays.toString(this.getKeyPassword()) + ", signatureAlgorithm=" + this.getSignatureAlgorithm() + ", validity=" + this.getValidity() + ", standardCertificateAttributes=" + this.getStandardCertificateAttributes() + ", keyUsage=" + this.getKeyUsage() + ", extendedKeyUsage=" + this.getExtendedKeyUsage() + ")";
    }
}

