/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.dto.tsb.ModifyPolicyDto;
import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Schema(description="Synchronous modify key request. Only supports SKA keys.")
public class SynchronousModifyKeyRequestDto {
    @NotEmpty
    @Schema(description="Name of the key which shall be modified.")
    private String modifyKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the modify key."), schema=@Schema(pattern="^.{1}$"))
    private char[] keyPassword;
    @NotNull
    private ModifyPolicyDto policy;
    @ArraySchema(schema=@Schema(description="Signed approvals that are used to synchronously modify with an SKA key. A single signed approval is a base64 encoded value that consists of the following components:\n1. The header containing the total size.\n2. The approvalToBeSigned which is the approval token that was signed by the approval client.\n3. The DER encoded signature of the token done by the approval client.\n4. The DER encoded public key of the approval client.", format="base64"))
    private List<@Base64Encoded String> signedApprovals = new ArrayList<String>();

    public String getModifyKeyName() {
        return this.modifyKeyName;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public ModifyPolicyDto getPolicy() {
        return this.policy;
    }

    public List<@Base64Encoded String> getSignedApprovals() {
        return this.signedApprovals;
    }

    public void setModifyKeyName(String modifyKeyName) {
        this.modifyKeyName = modifyKeyName;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setPolicy(ModifyPolicyDto policy) {
        this.policy = policy;
    }

    public void setSignedApprovals(List<@Base64Encoded String> signedApprovals) {
        this.signedApprovals = signedApprovals;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronousModifyKeyRequestDto)) {
            return false;
        }
        SynchronousModifyKeyRequestDto other = (SynchronousModifyKeyRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$modifyKeyName = this.getModifyKeyName();
        String other$modifyKeyName = other.getModifyKeyName();
        if (this$modifyKeyName == null ? other$modifyKeyName != null : !this$modifyKeyName.equals(other$modifyKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyPassword(), other.getKeyPassword())) {
            return false;
        }
        ModifyPolicyDto this$policy = this.getPolicy();
        ModifyPolicyDto other$policy = other.getPolicy();
        if (this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy)) {
            return false;
        }
        List<String> this$signedApprovals = this.getSignedApprovals();
        List<String> other$signedApprovals = other.getSignedApprovals();
        return !(this$signedApprovals == null ? other$signedApprovals != null : !((Object)this$signedApprovals).equals(other$signedApprovals));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SynchronousModifyKeyRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $modifyKeyName = this.getModifyKeyName();
        result = result * 59 + ($modifyKeyName == null ? 43 : $modifyKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        ModifyPolicyDto $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        List<String> $signedApprovals = this.getSignedApprovals();
        result = result * 59 + ($signedApprovals == null ? 43 : ((Object)$signedApprovals).hashCode());
        return result;
    }

    public String toString() {
        return "SynchronousModifyKeyRequestDto(modifyKeyName=" + this.getModifyKeyName() + ", keyPassword=" + Arrays.toString(this.getKeyPassword()) + ", policy=" + this.getPolicy() + ", signedApprovals=" + this.getSignedApprovals() + ")";
    }
}

