/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.enums.tsb.PayloadType;
import com.securosys.tee.enums.tsb.SignatureAlgorithm;
import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Schema(description="Synchronous sign request.")
public class SynchronousSignRequestDto {
    @NotEmpty
    @Base64Encoded
    @Schema(description="Payload that shall be signed.", format="base64")
    private String payload;
    @Schema(description="The type of the payload.", defaultValue="UNSPECIFIED")
    private PayloadType payloadType = PayloadType.UNSPECIFIED;
    @NotEmpty
    @Schema(description="Name of the key with which the request shall be signed. Note: to create a sign request for a BIP32 derived key, make sure you have already created a master key that is BIP32 capable. Then use the master key name and add the derivation path (e.g. \"TESTKEY/0'/1'/2\").")
    private String signKeyName;
    @Base64Encoded
    @Schema(description="External key object with which the request shall be signed. Subscription for External Keystore required.", format="base64")
    private String signKeyObject;
    @ArraySchema(arraySchema=@Schema(description="Password of the sign key. If a derived key should be used for signing the key password of the master key must be specified."), schema=@Schema(pattern="^.{1}$"))
    private char[] keyPassword;
    @Base64Encoded
    @Schema(description="Additional meta data that will be provided to the approval client.", format="base64")
    private String metaData;
    @Base64Encoded
    @Schema(description="Signature for the meta data.", format="base64")
    private String metaDataSignature;
    @NotNull
    @Schema(description="The signature algorithm to be used. The chosen algorithm has to be compatible with the type of the key referenced by the signKeyName param.")
    private SignatureAlgorithm signatureAlgorithm;
    @Schema(description="The type of the signature result. The result is in any case base64-encoded", example="DER", allowableValues={"ETH", "DER"})
    private String signatureType;
    @ArraySchema(schema=@Schema(description="Signed approvals that are used to synchronously sign with a SKA key. A single signed approval is a base64 encoded value that consists of the following components:\n1. The header containing the total size.\n2. The approvalToBeSigned which is the approval token that was signed by the approval client.\n3. The DER encoded signature of the token done by the approval client.\n4. The DER encoded public key of the approval client.", format="base64"))
    private List<@Base64Encoded String> signedApprovals = new ArrayList<String>();

    public String getPayload() {
        return this.payload;
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public String getSignKeyName() {
        return this.signKeyName;
    }

    public String getSignKeyObject() {
        return this.signKeyObject;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String getMetaDataSignature() {
        return this.metaDataSignature;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getSignatureType() {
        return this.signatureType;
    }

    public List<@Base64Encoded String> getSignedApprovals() {
        return this.signedApprovals;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setPayloadType(PayloadType payloadType) {
        this.payloadType = payloadType;
    }

    public void setSignKeyName(String signKeyName) {
        this.signKeyName = signKeyName;
    }

    public void setSignKeyObject(String signKeyObject) {
        this.signKeyObject = signKeyObject;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    public void setMetaDataSignature(String metaDataSignature) {
        this.metaDataSignature = metaDataSignature;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public void setSignatureType(String signatureType) {
        this.signatureType = signatureType;
    }

    public void setSignedApprovals(List<@Base64Encoded String> signedApprovals) {
        this.signedApprovals = signedApprovals;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronousSignRequestDto)) {
            return false;
        }
        SynchronousSignRequestDto other = (SynchronousSignRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$payload = this.getPayload();
        String other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        PayloadType this$payloadType = this.getPayloadType();
        PayloadType other$payloadType = other.getPayloadType();
        if (this$payloadType == null ? other$payloadType != null : !((Object)((Object)this$payloadType)).equals((Object)other$payloadType)) {
            return false;
        }
        String this$signKeyName = this.getSignKeyName();
        String other$signKeyName = other.getSignKeyName();
        if (this$signKeyName == null ? other$signKeyName != null : !this$signKeyName.equals(other$signKeyName)) {
            return false;
        }
        String this$signKeyObject = this.getSignKeyObject();
        String other$signKeyObject = other.getSignKeyObject();
        if (this$signKeyObject == null ? other$signKeyObject != null : !this$signKeyObject.equals(other$signKeyObject)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyPassword(), other.getKeyPassword())) {
            return false;
        }
        String this$metaData = this.getMetaData();
        String other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData)) {
            return false;
        }
        String this$metaDataSignature = this.getMetaDataSignature();
        String other$metaDataSignature = other.getMetaDataSignature();
        if (this$metaDataSignature == null ? other$metaDataSignature != null : !this$metaDataSignature.equals(other$metaDataSignature)) {
            return false;
        }
        SignatureAlgorithm this$signatureAlgorithm = this.getSignatureAlgorithm();
        SignatureAlgorithm other$signatureAlgorithm = other.getSignatureAlgorithm();
        if (this$signatureAlgorithm == null ? other$signatureAlgorithm != null : !((Object)((Object)this$signatureAlgorithm)).equals((Object)other$signatureAlgorithm)) {
            return false;
        }
        String this$signatureType = this.getSignatureType();
        String other$signatureType = other.getSignatureType();
        if (this$signatureType == null ? other$signatureType != null : !this$signatureType.equals(other$signatureType)) {
            return false;
        }
        List<String> this$signedApprovals = this.getSignedApprovals();
        List<String> other$signedApprovals = other.getSignedApprovals();
        return !(this$signedApprovals == null ? other$signedApprovals != null : !((Object)this$signedApprovals).equals(other$signedApprovals));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SynchronousSignRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        PayloadType $payloadType = this.getPayloadType();
        result = result * 59 + ($payloadType == null ? 43 : ((Object)((Object)$payloadType)).hashCode());
        String $signKeyName = this.getSignKeyName();
        result = result * 59 + ($signKeyName == null ? 43 : $signKeyName.hashCode());
        String $signKeyObject = this.getSignKeyObject();
        result = result * 59 + ($signKeyObject == null ? 43 : $signKeyObject.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        String $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
        String $metaDataSignature = this.getMetaDataSignature();
        result = result * 59 + ($metaDataSignature == null ? 43 : $metaDataSignature.hashCode());
        SignatureAlgorithm $signatureAlgorithm = this.getSignatureAlgorithm();
        result = result * 59 + ($signatureAlgorithm == null ? 43 : ((Object)((Object)$signatureAlgorithm)).hashCode());
        String $signatureType = this.getSignatureType();
        result = result * 59 + ($signatureType == null ? 43 : $signatureType.hashCode());
        List<String> $signedApprovals = this.getSignedApprovals();
        result = result * 59 + ($signedApprovals == null ? 43 : ((Object)$signedApprovals).hashCode());
        return result;
    }

    public String toString() {
        return "SynchronousSignRequestDto(payload=" + this.getPayload() + ", payloadType=" + this.getPayloadType() + ", signKeyName=" + this.getSignKeyName() + ", signKeyObject=" + this.getSignKeyObject() + ", keyPassword=" + Arrays.toString(this.getKeyPassword()) + ", metaData=" + this.getMetaData() + ", metaDataSignature=" + this.getMetaDataSignature() + ", signatureAlgorithm=" + this.getSignatureAlgorithm() + ", signatureType=" + this.getSignatureType() + ", signedApprovals=" + this.getSignedApprovals() + ")";
    }
}

