/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.response;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.securosys.tee.dto.tsb.PolicyDto;
import com.securosys.tee.dto.tsb.response.AddressTruncatedDto;
import com.securosys.tee.dto.tsb.response.DerivedKeyAttributesDto;
import io.swagger.v3.oas.annotations.media.Schema;

@JacksonXmlRootElement(localName="private_key")
@Schema(description="Response containing information about the key.")
public class KeyAttributesDto {
    @Schema(description="The name of the key.")
    private String label;
    @Schema(description="The id of the key.", nullable=true)
    private String id;
    @Schema(description="The id of the external key.", nullable=true)
    private String uuid;
    @Schema(description="The algorithm with which the key was created.", example="EC")
    private String algorithm;
    @JacksonXmlProperty(localName="algorithm_oid")
    @Schema(description="The oid of the algorithm with which the key was created.", example="1.2.840.10045.2.1")
    private String algorithmOid;
    @JacksonXmlProperty(localName="curve_oid")
    @Schema(description="The oid of the curve used for the EC algorithm (only set if the algorithm is EC).", example="1.3.132.0.34", nullable=true)
    private String curveOid;
    @JacksonXmlProperty(localName="derivation_value")
    @Schema(description="The derived key attributes", nullable=true)
    private DerivedKeyAttributesDto derivedAttributes;
    @JacksonXmlProperty(localName="key_size")
    @Schema(description="The length of the key. Only set if the algorithm is RSA, DSA or ISS. For ISS this attribute represents the security level.")
    private Integer keySize;
    @JacksonXmlProperty(localName="create_time")
    @Schema(description="The time at which the key was created on the HSM.")
    private String createTime;
    @JacksonXmlProperty(localName="attest_time")
    @Schema(description="The time at which the key was attested on the HSM.")
    private String attestTime;
    @JacksonXmlProperty(localName="public_key")
    @Schema(description="The public key from the created private key.\nThe public key is base64(DER/ASN.1) encoded, as supported by e.g. OpenSSL, Java and many other languages/tools.\nDecode using OpenSSL:\necho -n $EXAMPLE | base64 -D | openssl asn1parse -inform DER -dump", nullable=true)
    private String publicKey;
    @JacksonXmlProperty(localName="address_truncated")
    private AddressTruncatedDto addressTruncated;
    private Attributes attributes;
    private PolicyDto policy;

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getAlgorithmOid() {
        return this.algorithmOid;
    }

    public String getCurveOid() {
        return this.curveOid;
    }

    public DerivedKeyAttributesDto getDerivedAttributes() {
        return this.derivedAttributes;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getAttestTime() {
        return this.attestTime;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public AddressTruncatedDto getAddressTruncated() {
        return this.addressTruncated;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public PolicyDto getPolicy() {
        return this.policy;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @JacksonXmlProperty(localName="algorithm_oid")
    public void setAlgorithmOid(String algorithmOid) {
        this.algorithmOid = algorithmOid;
    }

    @JacksonXmlProperty(localName="curve_oid")
    public void setCurveOid(String curveOid) {
        this.curveOid = curveOid;
    }

    @JacksonXmlProperty(localName="derivation_value")
    public void setDerivedAttributes(DerivedKeyAttributesDto derivedAttributes) {
        this.derivedAttributes = derivedAttributes;
    }

    @JacksonXmlProperty(localName="key_size")
    public void setKeySize(Integer keySize) {
        this.keySize = keySize;
    }

    @JacksonXmlProperty(localName="create_time")
    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    @JacksonXmlProperty(localName="attest_time")
    public void setAttestTime(String attestTime) {
        this.attestTime = attestTime;
    }

    @JacksonXmlProperty(localName="public_key")
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @JacksonXmlProperty(localName="address_truncated")
    public void setAddressTruncated(AddressTruncatedDto addressTruncated) {
        this.addressTruncated = addressTruncated;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public void setPolicy(PolicyDto policy) {
        this.policy = policy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyAttributesDto)) {
            return false;
        }
        KeyAttributesDto other = (KeyAttributesDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$keySize = this.getKeySize();
        Integer other$keySize = other.getKeySize();
        if (this$keySize == null ? other$keySize != null : !((Object)this$keySize).equals(other$keySize)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        String this$algorithmOid = this.getAlgorithmOid();
        String other$algorithmOid = other.getAlgorithmOid();
        if (this$algorithmOid == null ? other$algorithmOid != null : !this$algorithmOid.equals(other$algorithmOid)) {
            return false;
        }
        String this$curveOid = this.getCurveOid();
        String other$curveOid = other.getCurveOid();
        if (this$curveOid == null ? other$curveOid != null : !this$curveOid.equals(other$curveOid)) {
            return false;
        }
        DerivedKeyAttributesDto this$derivedAttributes = this.getDerivedAttributes();
        DerivedKeyAttributesDto other$derivedAttributes = other.getDerivedAttributes();
        if (this$derivedAttributes == null ? other$derivedAttributes != null : !((Object)this$derivedAttributes).equals(other$derivedAttributes)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$attestTime = this.getAttestTime();
        String other$attestTime = other.getAttestTime();
        if (this$attestTime == null ? other$attestTime != null : !this$attestTime.equals(other$attestTime)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        AddressTruncatedDto this$addressTruncated = this.getAddressTruncated();
        AddressTruncatedDto other$addressTruncated = other.getAddressTruncated();
        if (this$addressTruncated == null ? other$addressTruncated != null : !((Object)this$addressTruncated).equals(other$addressTruncated)) {
            return false;
        }
        Attributes this$attributes = this.getAttributes();
        Attributes other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        PolicyDto this$policy = this.getPolicy();
        PolicyDto other$policy = other.getPolicy();
        return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyAttributesDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $keySize = this.getKeySize();
        result = result * 59 + ($keySize == null ? 43 : ((Object)$keySize).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        String $algorithmOid = this.getAlgorithmOid();
        result = result * 59 + ($algorithmOid == null ? 43 : $algorithmOid.hashCode());
        String $curveOid = this.getCurveOid();
        result = result * 59 + ($curveOid == null ? 43 : $curveOid.hashCode());
        DerivedKeyAttributesDto $derivedAttributes = this.getDerivedAttributes();
        result = result * 59 + ($derivedAttributes == null ? 43 : ((Object)$derivedAttributes).hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $attestTime = this.getAttestTime();
        result = result * 59 + ($attestTime == null ? 43 : $attestTime.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        AddressTruncatedDto $addressTruncated = this.getAddressTruncated();
        result = result * 59 + ($addressTruncated == null ? 43 : ((Object)$addressTruncated).hashCode());
        Attributes $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        PolicyDto $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        return result;
    }

    public String toString() {
        return "KeyAttributesDto(label=" + this.getLabel() + ", id=" + this.getId() + ", uuid=" + this.getUuid() + ", algorithm=" + this.getAlgorithm() + ", algorithmOid=" + this.getAlgorithmOid() + ", curveOid=" + this.getCurveOid() + ", derivedAttributes=" + this.getDerivedAttributes() + ", keySize=" + this.getKeySize() + ", createTime=" + this.getCreateTime() + ", attestTime=" + this.getAttestTime() + ", publicKey=" + this.getPublicKey() + ", addressTruncated=" + this.getAddressTruncated() + ", attributes=" + this.getAttributes() + ", policy=" + this.getPolicy() + ")";
    }

    @Schema(description="The attributes of a key.")
    public static class Attributes {
        @Schema(description="If true the key can be used to decrypt data.")
        private Boolean decrypt;
        @Schema(description="If true the key can sign.")
        private Boolean sign;
        @JacksonXmlProperty(localName="eka_sign")
        @Schema(nullable=true)
        private Boolean ekaSign;
        @Schema(description="If true the key can be used to unwrap keys.")
        private Boolean unwrap;
        @Schema(description="If true it is possible to derive from this key.")
        private Boolean derive;
        @Schema(description="If true the key is sensitive.")
        private Boolean sensitive;
        @JacksonXmlProperty(localName="always_sensitive")
        @Schema(description="Is true if the key was always sensitive since its creation.")
        private Boolean alwaysSensitive;
        @Schema(description="If true the key is extractable. Keys with smart key attributes are never extractable.")
        private Boolean extractable;
        @JacksonXmlProperty(localName="never_extractable")
        @Schema(description="Is true if the key was never extractable since its creation.")
        private Boolean neverExtractable;
        @Schema(description="If true the key can be modified.")
        private Boolean modifiable;
        @Schema(description="If true the encrypted key is stored in an external memory")
        private Boolean copyable;
        @Schema(description="If true the key can be deleted.")
        private Boolean destroyable;

        public Boolean getDecrypt() {
            return this.decrypt;
        }

        public Boolean getSign() {
            return this.sign;
        }

        public Boolean getEkaSign() {
            return this.ekaSign;
        }

        public Boolean getUnwrap() {
            return this.unwrap;
        }

        public Boolean getDerive() {
            return this.derive;
        }

        public Boolean getSensitive() {
            return this.sensitive;
        }

        public Boolean getAlwaysSensitive() {
            return this.alwaysSensitive;
        }

        public Boolean getExtractable() {
            return this.extractable;
        }

        public Boolean getNeverExtractable() {
            return this.neverExtractable;
        }

        public Boolean getModifiable() {
            return this.modifiable;
        }

        public Boolean getCopyable() {
            return this.copyable;
        }

        public Boolean getDestroyable() {
            return this.destroyable;
        }

        public void setDecrypt(Boolean decrypt) {
            this.decrypt = decrypt;
        }

        public void setSign(Boolean sign) {
            this.sign = sign;
        }

        @JacksonXmlProperty(localName="eka_sign")
        public void setEkaSign(Boolean ekaSign) {
            this.ekaSign = ekaSign;
        }

        public void setUnwrap(Boolean unwrap) {
            this.unwrap = unwrap;
        }

        public void setDerive(Boolean derive) {
            this.derive = derive;
        }

        public void setSensitive(Boolean sensitive) {
            this.sensitive = sensitive;
        }

        @JacksonXmlProperty(localName="always_sensitive")
        public void setAlwaysSensitive(Boolean alwaysSensitive) {
            this.alwaysSensitive = alwaysSensitive;
        }

        public void setExtractable(Boolean extractable) {
            this.extractable = extractable;
        }

        @JacksonXmlProperty(localName="never_extractable")
        public void setNeverExtractable(Boolean neverExtractable) {
            this.neverExtractable = neverExtractable;
        }

        public void setModifiable(Boolean modifiable) {
            this.modifiable = modifiable;
        }

        public void setCopyable(Boolean copyable) {
            this.copyable = copyable;
        }

        public void setDestroyable(Boolean destroyable) {
            this.destroyable = destroyable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attributes)) {
                return false;
            }
            Attributes other = (Attributes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$decrypt = this.getDecrypt();
            Boolean other$decrypt = other.getDecrypt();
            if (this$decrypt == null ? other$decrypt != null : !((Object)this$decrypt).equals(other$decrypt)) {
                return false;
            }
            Boolean this$sign = this.getSign();
            Boolean other$sign = other.getSign();
            if (this$sign == null ? other$sign != null : !((Object)this$sign).equals(other$sign)) {
                return false;
            }
            Boolean this$ekaSign = this.getEkaSign();
            Boolean other$ekaSign = other.getEkaSign();
            if (this$ekaSign == null ? other$ekaSign != null : !((Object)this$ekaSign).equals(other$ekaSign)) {
                return false;
            }
            Boolean this$unwrap = this.getUnwrap();
            Boolean other$unwrap = other.getUnwrap();
            if (this$unwrap == null ? other$unwrap != null : !((Object)this$unwrap).equals(other$unwrap)) {
                return false;
            }
            Boolean this$derive = this.getDerive();
            Boolean other$derive = other.getDerive();
            if (this$derive == null ? other$derive != null : !((Object)this$derive).equals(other$derive)) {
                return false;
            }
            Boolean this$sensitive = this.getSensitive();
            Boolean other$sensitive = other.getSensitive();
            if (this$sensitive == null ? other$sensitive != null : !((Object)this$sensitive).equals(other$sensitive)) {
                return false;
            }
            Boolean this$alwaysSensitive = this.getAlwaysSensitive();
            Boolean other$alwaysSensitive = other.getAlwaysSensitive();
            if (this$alwaysSensitive == null ? other$alwaysSensitive != null : !((Object)this$alwaysSensitive).equals(other$alwaysSensitive)) {
                return false;
            }
            Boolean this$extractable = this.getExtractable();
            Boolean other$extractable = other.getExtractable();
            if (this$extractable == null ? other$extractable != null : !((Object)this$extractable).equals(other$extractable)) {
                return false;
            }
            Boolean this$neverExtractable = this.getNeverExtractable();
            Boolean other$neverExtractable = other.getNeverExtractable();
            if (this$neverExtractable == null ? other$neverExtractable != null : !((Object)this$neverExtractable).equals(other$neverExtractable)) {
                return false;
            }
            Boolean this$modifiable = this.getModifiable();
            Boolean other$modifiable = other.getModifiable();
            if (this$modifiable == null ? other$modifiable != null : !((Object)this$modifiable).equals(other$modifiable)) {
                return false;
            }
            Boolean this$copyable = this.getCopyable();
            Boolean other$copyable = other.getCopyable();
            if (this$copyable == null ? other$copyable != null : !((Object)this$copyable).equals(other$copyable)) {
                return false;
            }
            Boolean this$destroyable = this.getDestroyable();
            Boolean other$destroyable = other.getDestroyable();
            return !(this$destroyable == null ? other$destroyable != null : !((Object)this$destroyable).equals(other$destroyable));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Attributes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $decrypt = this.getDecrypt();
            result = result * 59 + ($decrypt == null ? 43 : ((Object)$decrypt).hashCode());
            Boolean $sign = this.getSign();
            result = result * 59 + ($sign == null ? 43 : ((Object)$sign).hashCode());
            Boolean $ekaSign = this.getEkaSign();
            result = result * 59 + ($ekaSign == null ? 43 : ((Object)$ekaSign).hashCode());
            Boolean $unwrap = this.getUnwrap();
            result = result * 59 + ($unwrap == null ? 43 : ((Object)$unwrap).hashCode());
            Boolean $derive = this.getDerive();
            result = result * 59 + ($derive == null ? 43 : ((Object)$derive).hashCode());
            Boolean $sensitive = this.getSensitive();
            result = result * 59 + ($sensitive == null ? 43 : ((Object)$sensitive).hashCode());
            Boolean $alwaysSensitive = this.getAlwaysSensitive();
            result = result * 59 + ($alwaysSensitive == null ? 43 : ((Object)$alwaysSensitive).hashCode());
            Boolean $extractable = this.getExtractable();
            result = result * 59 + ($extractable == null ? 43 : ((Object)$extractable).hashCode());
            Boolean $neverExtractable = this.getNeverExtractable();
            result = result * 59 + ($neverExtractable == null ? 43 : ((Object)$neverExtractable).hashCode());
            Boolean $modifiable = this.getModifiable();
            result = result * 59 + ($modifiable == null ? 43 : ((Object)$modifiable).hashCode());
            Boolean $copyable = this.getCopyable();
            result = result * 59 + ($copyable == null ? 43 : ((Object)$copyable).hashCode());
            Boolean $destroyable = this.getDestroyable();
            result = result * 59 + ($destroyable == null ? 43 : ((Object)$destroyable).hashCode());
            return result;
        }

        public String toString() {
            return "KeyAttributesDto.Attributes(decrypt=" + this.getDecrypt() + ", sign=" + this.getSign() + ", ekaSign=" + this.getEkaSign() + ", unwrap=" + this.getUnwrap() + ", derive=" + this.getDerive() + ", sensitive=" + this.getSensitive() + ", alwaysSensitive=" + this.getAlwaysSensitive() + ", extractable=" + this.getExtractable() + ", neverExtractable=" + this.getNeverExtractable() + ", modifiable=" + this.getModifiable() + ", copyable=" + this.getCopyable() + ", destroyable=" + this.getDestroyable() + ")";
        }
    }
}

