/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DatabaseConnection
implements Cloneable {
    @JsonIgnore
    private String host;
    @JsonIgnore
    private int port;
    @JsonIgnore
    private String database;
    @JsonIgnore
    private Map<String, String> parameters;
    private String username;
    private String password;
    private String table;
    @JsonIgnore
    private String dbType;

    @JsonProperty(value="url")
    public void setUrl(String url) throws URISyntaxException {
        if (url.startsWith("jdbc:postgresql://")) {
            this.dbType = "postgresql";
            this.parseUrl(url, "jdbc:postgresql://", 5432);
        } else if (url.startsWith("jdbc:mariadb://")) {
            this.dbType = "mariadb";
            this.parseUrl(url, "jdbc:mariadb://", 3306);
        } else if (url.startsWith("jdbc:h2:")) {
            this.dbType = "h2";
            String h2UrlPart = url.substring("jdbc:h2:".length());
            if (h2UrlPart.startsWith("mem:")) {
                this.host = null;
                this.port = -1;
                this.dbType = "h2:mem";
                this.database = h2UrlPart.substring("mem:".length());
            } else if (h2UrlPart.startsWith("file:")) {
                this.host = null;
                this.port = -1;
                this.dbType = "h2:file";
                this.database = h2UrlPart.substring("file:".length());
            } else if (h2UrlPart.startsWith("tcp://")) {
                URI uri = new URI("http://" + h2UrlPart.substring("tcp://".length()));
                this.host = uri.getHost();
                this.port = uri.getPort() == -1 ? 9092 : uri.getPort();
                this.database = uri.getPath().substring(1);
            } else {
                this.host = null;
                this.port = -1;
                this.database = h2UrlPart;
            }
            this.parameters = new HashMap<String, String>();
        } else {
            throw new IllegalArgumentException("Unsupported JDBC URL: " + url);
        }
    }

    private void parseUrl(String url, String prefix, int defaultPort) throws URISyntaxException {
        URI uri = new URI("http://" + url.substring(prefix.length()));
        this.host = uri.getHost();
        this.port = uri.getPort();
        if (this.host == null || this.port == -1) {
            String withoutPrefix = url.substring(prefix.length());
            String[] hostAndDb = withoutPrefix.split("/", 2);
            String[] hostPort = hostAndDb[0].split(":", 2);
            this.host = hostPort[0];
            this.port = hostPort.length > 1 ? Integer.parseInt(hostPort[1]) : defaultPort;
        }
        this.database = uri.getPath() != null && uri.getPath().length() > 1 ? uri.getPath().substring(1) : null;
        this.parameters = new HashMap<String, String>();
        String query = uri.getQuery();
        if (query != null) {
            for (String param : query.split("&")) {
                String[] kv = param.split("=", 2);
                if (kv.length != 2) continue;
                this.parameters.put(kv[0], kv[1]);
            }
        }
    }

    @JsonProperty(value="url")
    public String getUrl() {
        if (this.dbType == null) {
            this.dbType = "postgresql";
        }
        if (this.dbType.startsWith("h2")) {
            StringBuilder urlBuilder = new StringBuilder();
            if (this.host == null && this.port == -1) {
                if (this.dbType.startsWith("h2:mem") || this.database.startsWith("h2:file")) {
                    urlBuilder.append("jdbc:").append(this.dbType).append(":").append(this.database);
                } else {
                    urlBuilder.append("jdbc:h2:").append(this.database);
                }
            } else {
                String portPart = this.port == -1 ? "" : ":" + this.port;
                urlBuilder.append("jdbc:h2:tcp://").append(this.host).append(portPart).append("/").append(this.database);
            }
            if (this.parameters != null && !this.parameters.isEmpty()) {
                urlBuilder.append("?");
                this.parameters.forEach((key, value) -> urlBuilder.append((String)key).append("=").append((String)value).append("&"));
                urlBuilder.setLength(urlBuilder.length() - 1);
            } else {
                urlBuilder.append(";DB_CLOSE_DELAY=-1");
                urlBuilder.append(";DB_CLOSE_ON_EXIT=FALSE");
            }
            return urlBuilder.toString();
        }
        StringBuilder rebuiltUrl = new StringBuilder();
        rebuiltUrl.append("jdbc:").append(this.dbType).append("://").append(this.host).append(":").append(this.port).append("/").append(this.database);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            rebuiltUrl.append("?");
            this.parameters.forEach((key, value) -> rebuiltUrl.append((String)key).append("=").append((String)value).append("&"));
            rebuiltUrl.setLength(rebuiltUrl.length() - 1);
        }
        return rebuiltUrl.toString();
    }

    public DatabaseConnection(String url, String username, String password) throws URISyntaxException {
        this.username = username;
        this.password = password;
        this.setUrl(url);
    }

    public DatabaseConnection clone() {
        try {
            DatabaseConnection clone = (DatabaseConnection)super.clone();
            if (this.parameters != null) {
                clone.parameters = new HashMap<String, String>(this.parameters);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public DatabaseConnection() {
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTable() {
        return this.table;
    }

    public String getDbType() {
        return this.dbType;
    }

    @JsonIgnore
    public void setHost(String host) {
        this.host = host;
    }

    @JsonIgnore
    public void setPort(int port) {
        this.port = port;
    }

    @JsonIgnore
    public void setDatabase(String database) {
        this.database = database;
    }

    @JsonIgnore
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @JsonIgnore
    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseConnection)) {
            return false;
        }
        DatabaseConnection other = (DatabaseConnection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$dbType = this.getDbType();
        String other$dbType = other.getDbType();
        return !(this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseConnection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseConnection(host=" + this.getHost() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", parameters=" + this.getParameters() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", table=" + this.getTable() + ", dbType=" + this.getDbType() + ")";
    }
}

