/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.securosys.tee.dto.tsb.ModifyPolicyDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;

@Schema(description="The policy of a key. Only Asymmetric keys can have a policy (EC, ED, RSA,...). It contains the rules to use this key for signing a payload in a sign request, the rules to block and unblock this key, and the rules to modify the policy of this key. If a rule is empty the associated operation can be performed without any approvals. If the policy is empty the key does not use smart key attributes and it is not possible to add them later. If a policy is used with the key, the key cannot be exported.", nullable=true)
public class PolicyDto
extends ModifyPolicyDto {
    @JacksonXmlProperty(localName="key_status")
    @NotNull
    private KeyStatus keyStatus;

    public KeyStatus getKeyStatus() {
        return this.keyStatus;
    }

    public void setKeyStatus(KeyStatus keyStatus) {
        this.keyStatus = keyStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolicyDto)) {
            return false;
        }
        PolicyDto other = (PolicyDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyStatus this$keyStatus = this.getKeyStatus();
        KeyStatus other$keyStatus = other.getKeyStatus();
        return !(this$keyStatus == null ? other$keyStatus != null : !((Object)this$keyStatus).equals(other$keyStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PolicyDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        KeyStatus $keyStatus = this.getKeyStatus();
        result = result * 59 + ($keyStatus == null ? 43 : ((Object)$keyStatus).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PolicyDto(super=" + super.toString() + ", keyStatus=" + this.getKeyStatus() + ")";
    }

    @Schema(description="The status of a key.")
    public static class KeyStatus {
        @NotNull
        @Schema(description="If true the key is blocked.", example="false")
        private Boolean blocked;

        public Boolean getBlocked() {
            return this.blocked;
        }

        public void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyStatus)) {
                return false;
            }
            KeyStatus other = (KeyStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$blocked = this.getBlocked();
            Boolean other$blocked = other.getBlocked();
            return !(this$blocked == null ? other$blocked != null : !((Object)this$blocked).equals(other$blocked));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KeyStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $blocked = this.getBlocked();
            result = result * 59 + ($blocked == null ? 43 : ((Object)$blocked).hashCode());
            return result;
        }

        public String toString() {
            return "PolicyDto.KeyStatus(blocked=" + this.getBlocked() + ")";
        }
    }
}

