/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.enums.tsb.CipherAlgorithm;
import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

@Schema(description="Encrypt request.")
public class EncryptRequestDto {
    @NotEmpty
    @Base64Encoded
    @Schema(description="Payload (base64 encoded) that shall be encrypted.", format="byte")
    private String payload;
    @NotEmpty
    @Schema(description="Name of the key with which the payload shall be encrypted.")
    private String encryptKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the encrypt key. This is only necessary if the key algorithm is symmetric."), schema=@Schema(pattern="^.{1}$"))
    private char[] keyPassword;
    @NotNull
    @Schema(description="The cipher algorithm to be used.")
    private CipherAlgorithm cipherAlgorithm;
    @Base64Encoded
    @Schema(description="Additional authentication data (aad, base64 encoded) used for encryption with algorithm that support them.", format="base64")
    private String additionalAuthenticationData;
    @Schema(description="The MAC (Message Authentication Tag) is a fixed-length value as part of the AES-GCM encryption process, that is INCLUDED in the ciphertext and used to authenticatethe integrity of the data and the authenticity of the sender. \nSupported tag_length: 0, 64, 96, 104, 112, 120, 128", format="int")
    private int tagLength = 0;

    public String getPayload() {
        return this.payload;
    }

    public String getEncryptKeyName() {
        return this.encryptKeyName;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public CipherAlgorithm getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public String getAdditionalAuthenticationData() {
        return this.additionalAuthenticationData;
    }

    public int getTagLength() {
        return this.tagLength;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setEncryptKeyName(String encryptKeyName) {
        this.encryptKeyName = encryptKeyName;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setCipherAlgorithm(CipherAlgorithm cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public void setAdditionalAuthenticationData(String additionalAuthenticationData) {
        this.additionalAuthenticationData = additionalAuthenticationData;
    }

    public void setTagLength(int tagLength) {
        this.tagLength = tagLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptRequestDto)) {
            return false;
        }
        EncryptRequestDto other = (EncryptRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTagLength() != other.getTagLength()) {
            return false;
        }
        String this$payload = this.getPayload();
        String other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        String this$encryptKeyName = this.getEncryptKeyName();
        String other$encryptKeyName = other.getEncryptKeyName();
        if (this$encryptKeyName == null ? other$encryptKeyName != null : !this$encryptKeyName.equals(other$encryptKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyPassword(), other.getKeyPassword())) {
            return false;
        }
        CipherAlgorithm this$cipherAlgorithm = this.getCipherAlgorithm();
        CipherAlgorithm other$cipherAlgorithm = other.getCipherAlgorithm();
        if (this$cipherAlgorithm == null ? other$cipherAlgorithm != null : !((Object)((Object)this$cipherAlgorithm)).equals((Object)other$cipherAlgorithm)) {
            return false;
        }
        String this$additionalAuthenticationData = this.getAdditionalAuthenticationData();
        String other$additionalAuthenticationData = other.getAdditionalAuthenticationData();
        return !(this$additionalAuthenticationData == null ? other$additionalAuthenticationData != null : !this$additionalAuthenticationData.equals(other$additionalAuthenticationData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTagLength();
        String $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        String $encryptKeyName = this.getEncryptKeyName();
        result = result * 59 + ($encryptKeyName == null ? 43 : $encryptKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        CipherAlgorithm $cipherAlgorithm = this.getCipherAlgorithm();
        result = result * 59 + ($cipherAlgorithm == null ? 43 : ((Object)((Object)$cipherAlgorithm)).hashCode());
        String $additionalAuthenticationData = this.getAdditionalAuthenticationData();
        result = result * 59 + ($additionalAuthenticationData == null ? 43 : $additionalAuthenticationData.hashCode());
        return result;
    }

    public String toString() {
        return "EncryptRequestDto(payload=" + this.getPayload() + ", encryptKeyName=" + this.getEncryptKeyName() + ", keyPassword=" + Arrays.toString(this.getKeyPassword()) + ", cipherAlgorithm=" + this.getCipherAlgorithm() + ", additionalAuthenticationData=" + this.getAdditionalAuthenticationData() + ", tagLength=" + this.getTagLength() + ")";
    }
}

