/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;

@Schema(description="Unblock key request.")
public class UnblockKeyRequestDto {
    @NotEmpty
    @Schema(description="Name of the key which shall be unblocked.")
    private String unblockKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the unblock key."), schema=@Schema(pattern="^.{1}$"))
    private char[] keyPassword;
    @Base64Encoded
    @Schema(description="Additional meta data that will be provided to the approval client.", format="base64")
    private String metaData;
    @Base64Encoded
    @Schema(description="Signature for the meta data.", format="base64")
    private String metaDataSignature;

    public String getUnblockKeyName() {
        return this.unblockKeyName;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String getMetaDataSignature() {
        return this.metaDataSignature;
    }

    public void setUnblockKeyName(String unblockKeyName) {
        this.unblockKeyName = unblockKeyName;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    public void setMetaDataSignature(String metaDataSignature) {
        this.metaDataSignature = metaDataSignature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnblockKeyRequestDto)) {
            return false;
        }
        UnblockKeyRequestDto other = (UnblockKeyRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$unblockKeyName = this.getUnblockKeyName();
        String other$unblockKeyName = other.getUnblockKeyName();
        if (this$unblockKeyName == null ? other$unblockKeyName != null : !this$unblockKeyName.equals(other$unblockKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyPassword(), other.getKeyPassword())) {
            return false;
        }
        String this$metaData = this.getMetaData();
        String other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData)) {
            return false;
        }
        String this$metaDataSignature = this.getMetaDataSignature();
        String other$metaDataSignature = other.getMetaDataSignature();
        return !(this$metaDataSignature == null ? other$metaDataSignature != null : !this$metaDataSignature.equals(other$metaDataSignature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnblockKeyRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $unblockKeyName = this.getUnblockKeyName();
        result = result * 59 + ($unblockKeyName == null ? 43 : $unblockKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        String $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
        String $metaDataSignature = this.getMetaDataSignature();
        result = result * 59 + ($metaDataSignature == null ? 43 : $metaDataSignature.hashCode());
        return result;
    }

    public String toString() {
        return "UnblockKeyRequestDto(unblockKeyName=" + this.getUnblockKeyName() + ", keyPassword=" + Arrays.toString(this.getKeyPassword()) + ", metaData=" + this.getMetaData() + ", metaDataSignature=" + this.getMetaDataSignature() + ")";
    }
}

