/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.enums.tsb.WrapMethod;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

@Schema(description="Wrap key request.")
public class WrapKeyRequestDto {
    @NotEmpty
    @Schema(description="Name of the key that shall be wrapped")
    private String keyToBeWrapped;
    @ArraySchema(arraySchema=@Schema(description="Password of the key that shall be wrapped."), schema=@Schema(pattern="^.{1}$"))
    private char[] keyToBeWrappedPassword;
    @NotEmpty
    @Schema(description="Name of the key with which the key shall be wrapped.")
    private String wrapKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the wrap key."), schema=@Schema(pattern="^.{1}$"))
    private char[] wrapKeyPassword;
    @NotNull
    @Schema(description="The wrap method to be used. The chosen method has to be compatible with the types of the referenced keys")
    private WrapMethod wrapMethod;

    public String getKeyToBeWrapped() {
        return this.keyToBeWrapped;
    }

    public char[] getKeyToBeWrappedPassword() {
        return this.keyToBeWrappedPassword;
    }

    public String getWrapKeyName() {
        return this.wrapKeyName;
    }

    public char[] getWrapKeyPassword() {
        return this.wrapKeyPassword;
    }

    public WrapMethod getWrapMethod() {
        return this.wrapMethod;
    }

    public void setKeyToBeWrapped(String keyToBeWrapped) {
        this.keyToBeWrapped = keyToBeWrapped;
    }

    public void setKeyToBeWrappedPassword(char[] keyToBeWrappedPassword) {
        this.keyToBeWrappedPassword = keyToBeWrappedPassword;
    }

    public void setWrapKeyName(String wrapKeyName) {
        this.wrapKeyName = wrapKeyName;
    }

    public void setWrapKeyPassword(char[] wrapKeyPassword) {
        this.wrapKeyPassword = wrapKeyPassword;
    }

    public void setWrapMethod(WrapMethod wrapMethod) {
        this.wrapMethod = wrapMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WrapKeyRequestDto)) {
            return false;
        }
        WrapKeyRequestDto other = (WrapKeyRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$keyToBeWrapped = this.getKeyToBeWrapped();
        String other$keyToBeWrapped = other.getKeyToBeWrapped();
        if (this$keyToBeWrapped == null ? other$keyToBeWrapped != null : !this$keyToBeWrapped.equals(other$keyToBeWrapped)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyToBeWrappedPassword(), other.getKeyToBeWrappedPassword())) {
            return false;
        }
        String this$wrapKeyName = this.getWrapKeyName();
        String other$wrapKeyName = other.getWrapKeyName();
        if (this$wrapKeyName == null ? other$wrapKeyName != null : !this$wrapKeyName.equals(other$wrapKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getWrapKeyPassword(), other.getWrapKeyPassword())) {
            return false;
        }
        WrapMethod this$wrapMethod = this.getWrapMethod();
        WrapMethod other$wrapMethod = other.getWrapMethod();
        return !(this$wrapMethod == null ? other$wrapMethod != null : !((Object)((Object)this$wrapMethod)).equals((Object)other$wrapMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WrapKeyRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyToBeWrapped = this.getKeyToBeWrapped();
        result = result * 59 + ($keyToBeWrapped == null ? 43 : $keyToBeWrapped.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyToBeWrappedPassword());
        String $wrapKeyName = this.getWrapKeyName();
        result = result * 59 + ($wrapKeyName == null ? 43 : $wrapKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getWrapKeyPassword());
        WrapMethod $wrapMethod = this.getWrapMethod();
        result = result * 59 + ($wrapMethod == null ? 43 : ((Object)((Object)$wrapMethod)).hashCode());
        return result;
    }

    public String toString() {
        return "WrapKeyRequestDto(keyToBeWrapped=" + this.getKeyToBeWrapped() + ", keyToBeWrappedPassword=" + Arrays.toString(this.getKeyToBeWrappedPassword()) + ", wrapKeyName=" + this.getWrapKeyName() + ", wrapKeyPassword=" + Arrays.toString(this.getWrapKeyPassword()) + ", wrapMethod=" + this.getWrapMethod() + ")";
    }
}

