/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.securosys.tee.dto.tsb.request.SignedBlockKeyRequestDto;
import com.securosys.tee.dto.tsb.request.SignedCertificateRequestRequestDto;
import com.securosys.tee.dto.tsb.request.SignedDecryptRequestDto;
import com.securosys.tee.dto.tsb.request.SignedModifyKeyRequestDto;
import com.securosys.tee.dto.tsb.request.SignedSelfSignCertificateRequestDto;
import com.securosys.tee.dto.tsb.request.SignedSignCertificateRequestDto;
import com.securosys.tee.dto.tsb.request.SignedSignRequestDto;
import com.securosys.tee.dto.tsb.request.SignedUnblockKeyRequestDto;
import com.securosys.tee.dto.tsb.request.SignedUnwrapKeyRequestDto;
import com.securosys.tee.dto.tsb.response.RequestStatusDto;
import com.securosys.tee.enums.tsb.PayloadType;
import com.securosys.tee.enums.tsb.SignatureAlgorithm;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="Response containing the requested tasks with the specified detail level.")
public class GetTasksResponseDto {
    @ArraySchema(schema=@Schema(description="The requested tasks."))
    private List<TaskLevel> tasks;

    public List<TaskLevel> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<TaskLevel> tasks) {
        this.tasks = tasks;
    }

    @Schema(description="Task with detail level 6.")
    public static class TaskLevel6
    extends TaskLevel5 {
        private RequestStatusDto requestStatus;

        public RequestStatusDto getRequestStatus() {
            return this.requestStatus;
        }

        public void setRequestStatus(RequestStatusDto requestStatus) {
            this.requestStatus = requestStatus;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskLevel6)) {
                return false;
            }
            TaskLevel6 other = (TaskLevel6)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestStatusDto this$requestStatus = this.getRequestStatus();
            RequestStatusDto other$requestStatus = other.getRequestStatus();
            return !(this$requestStatus == null ? other$requestStatus != null : !this$requestStatus.equals(other$requestStatus));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TaskLevel6;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            RequestStatusDto $requestStatus = this.getRequestStatus();
            result = result * 59 + ($requestStatus == null ? 43 : $requestStatus.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "GetTasksResponseDto.TaskLevel6(super=" + super.toString() + ", requestStatus=" + this.getRequestStatus() + ")";
        }
    }

    @Schema(description="Task with detail level 5.")
    public static class TaskLevel5
    extends TaskLevel4 {
        @Schema(description="The key attributes for the signing key in XML format.")
        private String keyAttributes;
        @Schema(description="Signature for the key attributes as provided by the HSM (base64 encoded).", format="byte")
        private String keyAttributesSignature;

        public String getKeyAttributes() {
            return this.keyAttributes;
        }

        public String getKeyAttributesSignature() {
            return this.keyAttributesSignature;
        }

        public void setKeyAttributes(String keyAttributes) {
            this.keyAttributes = keyAttributes;
        }

        public void setKeyAttributesSignature(String keyAttributesSignature) {
            this.keyAttributesSignature = keyAttributesSignature;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskLevel5)) {
                return false;
            }
            TaskLevel5 other = (TaskLevel5)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$keyAttributes = this.getKeyAttributes();
            String other$keyAttributes = other.getKeyAttributes();
            if (this$keyAttributes == null ? other$keyAttributes != null : !this$keyAttributes.equals(other$keyAttributes)) {
                return false;
            }
            String this$keyAttributesSignature = this.getKeyAttributesSignature();
            String other$keyAttributesSignature = other.getKeyAttributesSignature();
            return !(this$keyAttributesSignature == null ? other$keyAttributesSignature != null : !this$keyAttributesSignature.equals(other$keyAttributesSignature));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TaskLevel5;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $keyAttributes = this.getKeyAttributes();
            result = result * 59 + ($keyAttributes == null ? 43 : $keyAttributes.hashCode());
            String $keyAttributesSignature = this.getKeyAttributesSignature();
            result = result * 59 + ($keyAttributesSignature == null ? 43 : $keyAttributesSignature.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "GetTasksResponseDto.TaskLevel5(super=" + super.toString() + ", keyAttributes=" + this.getKeyAttributes() + ", keyAttributesSignature=" + this.getKeyAttributesSignature() + ")";
        }
    }

    @Schema(description="Task with detail level 4.")
    public static class TaskLevel4
    extends TaskLevel3 {
        @Schema(description="Timestamp as provided by the HSM. For timestamps a TLV (type length value) format is used. See the following example on how to decode a timestamp provided by the HSM. <i>Please note that little endian encoding is used and padding is 4 byte.</i><br>Example:<br>64 00 00 00<br><i>length 100 byte</i><br><br>57 10<br><i>type 0x1057=EkaUsagePayload (could also be 0x1058 EkaModifyPayload)</i><br><br>16 00<br><i>length=22 byte</i><br><br>54 68 69 73 49 73 4A 75 73 74 41 50 61 79 6C 6F 61 64 54 65 73 74<br><i>payload</i><br><br>00 00<br><i>padding</i><br><br>0701<br><i>type 0x0107=Seconds since epoch</i><br><br>0800<br><i>length 8 byte</i><br><br>82 CE 5F 5E 00 00 00 00<br><i>seconds since epoch</i><br><br>0210<br><i>type 0x1002=LABEL_UTF8</i><br><br>3500<br><i>length 53 byte</i><br><br>696E746567726974794B65794E616D652D35656431303438662D353864372D346237302D386166342D643363333735666239636337<br><i>label = 'integrityKeyName-5ed1048f-58d7-4b70-8af4-d3c375fb9cc7'</i><br><br>000000<br><i>padding</i>", format="base64")
        private String timestamp;
        @Schema(description="Signature of the timestamp as provided by the HSM (using integrity key). Signature is DER encoded and can directly be used in e.g. the Java signature verifier.<br>Example (ECDSA):<br>echo \"MEYCIQCx7KRl7jrxsiNfMQ19ltO0/0sbFsQY1fMvJ7SXfCrDnwIhAOgGm3Un8QQA9vreOB62/lo+Dgs5EoZzWhcjZ4/6OQyN\" | base64 -D | openssl asn1parse -inform DER -i<br>    0:d=0  hl=2 l=  70 cons: SEQUENCE<br>    2:d=1  hl=2 l=  33 prim:  INTEGER           :B1ECA465EE3AF1B2235F310D7D96D3B4FF4B1B16C418D5F32F27B4977C2AC39F<br>   37:d=1  hl=2 l=  33 prim:  INTEGER           :E8069B7527F10400F6FADE381EB6FE5A3E0E0B391286735A1723678FFA390C8D", format="base64")
        private String timestampSignature;
        @Schema(description="The algorithm that was used to sign the timestamp")
        private SignatureAlgorithm timestampSignatureAlgorithm;
        @Schema(description="DER encoded signature of the timestamp including the algorithm used. This representation is expected as part of the approval token signed by the approver. It is a combination of 'timestampSignature' and 'timestampSignatureAlgorithm' and provided for convenience.<br>Example (ECDSA)<br>echo \"MFkwDAYIKoZIzj0EAwIFAANJADBGAiEAseykZe468bIjXzENfZbTtP9LGxbEGNXzLye0l3wqw58CIQDoBpt1J/EEAPb63jgetv5aPg4LORKGc1oXI2eP+jkMjQ==\" | base64 -D | openssl asn1parse -inform DER -i<br>    0:d=0  hl=2 l=  89 cons: SEQUENCE<br>    2:d=1  hl=2 l=  12 cons:  SEQUENCE<br>    4:d=2  hl=2 l=   8 prim:   OBJECT            :ecdsa-with-SHA256<br>   14:d=2  hl=2 l=   0 prim:   NULL<br>   16:d=1  hl=2 l=  73 prim:  BIT STRING", format="base64")
        private String timestampSignatureWithAlgorithm;

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getTimestampSignature() {
            return this.timestampSignature;
        }

        public SignatureAlgorithm getTimestampSignatureAlgorithm() {
            return this.timestampSignatureAlgorithm;
        }

        public String getTimestampSignatureWithAlgorithm() {
            return this.timestampSignatureWithAlgorithm;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public void setTimestampSignature(String timestampSignature) {
            this.timestampSignature = timestampSignature;
        }

        public void setTimestampSignatureAlgorithm(SignatureAlgorithm timestampSignatureAlgorithm) {
            this.timestampSignatureAlgorithm = timestampSignatureAlgorithm;
        }

        public void setTimestampSignatureWithAlgorithm(String timestampSignatureWithAlgorithm) {
            this.timestampSignatureWithAlgorithm = timestampSignatureWithAlgorithm;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskLevel4)) {
                return false;
            }
            TaskLevel4 other = (TaskLevel4)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
                return false;
            }
            String this$timestampSignature = this.getTimestampSignature();
            String other$timestampSignature = other.getTimestampSignature();
            if (this$timestampSignature == null ? other$timestampSignature != null : !this$timestampSignature.equals(other$timestampSignature)) {
                return false;
            }
            SignatureAlgorithm this$timestampSignatureAlgorithm = this.getTimestampSignatureAlgorithm();
            SignatureAlgorithm other$timestampSignatureAlgorithm = other.getTimestampSignatureAlgorithm();
            if (this$timestampSignatureAlgorithm == null ? other$timestampSignatureAlgorithm != null : !((Object)((Object)this$timestampSignatureAlgorithm)).equals((Object)other$timestampSignatureAlgorithm)) {
                return false;
            }
            String this$timestampSignatureWithAlgorithm = this.getTimestampSignatureWithAlgorithm();
            String other$timestampSignatureWithAlgorithm = other.getTimestampSignatureWithAlgorithm();
            return !(this$timestampSignatureWithAlgorithm == null ? other$timestampSignatureWithAlgorithm != null : !this$timestampSignatureWithAlgorithm.equals(other$timestampSignatureWithAlgorithm));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TaskLevel4;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            String $timestampSignature = this.getTimestampSignature();
            result = result * 59 + ($timestampSignature == null ? 43 : $timestampSignature.hashCode());
            SignatureAlgorithm $timestampSignatureAlgorithm = this.getTimestampSignatureAlgorithm();
            result = result * 59 + ($timestampSignatureAlgorithm == null ? 43 : ((Object)((Object)$timestampSignatureAlgorithm)).hashCode());
            String $timestampSignatureWithAlgorithm = this.getTimestampSignatureWithAlgorithm();
            result = result * 59 + ($timestampSignatureWithAlgorithm == null ? 43 : $timestampSignatureWithAlgorithm.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "GetTasksResponseDto.TaskLevel4(super=" + super.toString() + ", timestamp=" + this.getTimestamp() + ", timestampSignature=" + this.getTimestampSignature() + ", timestampSignatureAlgorithm=" + this.getTimestampSignatureAlgorithm() + ", timestampSignatureWithAlgorithm=" + this.getTimestampSignatureWithAlgorithm() + ")";
        }
    }

    @Schema(description="Task with detail level 3.")
    public static class TaskLevel3
    extends TaskLevel2 {
        @Schema(description="The original request as sent by the caller. To be used for signature verification.")
        private String requestBase64;
        private SignedSignRequestDto signedSignRequest;
        private SignedModifyKeyRequestDto signedModifyKeyRequest;
        private SignedBlockKeyRequestDto signedBlockKeyRequest;
        private SignedUnblockKeyRequestDto signedUnblockKeyRequest;
        private SignedDecryptRequestDto signedDecryptRequest;
        private SignedUnwrapKeyRequestDto signedUnwrapKeyRequest;
        private SignedCertificateRequestRequestDto signedCertificateRequestRequest;
        private SignedSignCertificateRequestDto signedSignCertificateRequest;
        private SignedSelfSignCertificateRequestDto signedSelfSignCertificateRequestDto;

        public String getRequestBase64() {
            return this.requestBase64;
        }

        public SignedSignRequestDto getSignedSignRequest() {
            return this.signedSignRequest;
        }

        public SignedModifyKeyRequestDto getSignedModifyKeyRequest() {
            return this.signedModifyKeyRequest;
        }

        public SignedBlockKeyRequestDto getSignedBlockKeyRequest() {
            return this.signedBlockKeyRequest;
        }

        public SignedUnblockKeyRequestDto getSignedUnblockKeyRequest() {
            return this.signedUnblockKeyRequest;
        }

        public SignedDecryptRequestDto getSignedDecryptRequest() {
            return this.signedDecryptRequest;
        }

        public SignedUnwrapKeyRequestDto getSignedUnwrapKeyRequest() {
            return this.signedUnwrapKeyRequest;
        }

        public SignedCertificateRequestRequestDto getSignedCertificateRequestRequest() {
            return this.signedCertificateRequestRequest;
        }

        public SignedSignCertificateRequestDto getSignedSignCertificateRequest() {
            return this.signedSignCertificateRequest;
        }

        public SignedSelfSignCertificateRequestDto getSignedSelfSignCertificateRequestDto() {
            return this.signedSelfSignCertificateRequestDto;
        }

        public void setRequestBase64(String requestBase64) {
            this.requestBase64 = requestBase64;
        }

        public void setSignedSignRequest(SignedSignRequestDto signedSignRequest) {
            this.signedSignRequest = signedSignRequest;
        }

        public void setSignedModifyKeyRequest(SignedModifyKeyRequestDto signedModifyKeyRequest) {
            this.signedModifyKeyRequest = signedModifyKeyRequest;
        }

        public void setSignedBlockKeyRequest(SignedBlockKeyRequestDto signedBlockKeyRequest) {
            this.signedBlockKeyRequest = signedBlockKeyRequest;
        }

        public void setSignedUnblockKeyRequest(SignedUnblockKeyRequestDto signedUnblockKeyRequest) {
            this.signedUnblockKeyRequest = signedUnblockKeyRequest;
        }

        public void setSignedDecryptRequest(SignedDecryptRequestDto signedDecryptRequest) {
            this.signedDecryptRequest = signedDecryptRequest;
        }

        public void setSignedUnwrapKeyRequest(SignedUnwrapKeyRequestDto signedUnwrapKeyRequest) {
            this.signedUnwrapKeyRequest = signedUnwrapKeyRequest;
        }

        public void setSignedCertificateRequestRequest(SignedCertificateRequestRequestDto signedCertificateRequestRequest) {
            this.signedCertificateRequestRequest = signedCertificateRequestRequest;
        }

        public void setSignedSignCertificateRequest(SignedSignCertificateRequestDto signedSignCertificateRequest) {
            this.signedSignCertificateRequest = signedSignCertificateRequest;
        }

        public void setSignedSelfSignCertificateRequestDto(SignedSelfSignCertificateRequestDto signedSelfSignCertificateRequestDto) {
            this.signedSelfSignCertificateRequestDto = signedSelfSignCertificateRequestDto;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskLevel3)) {
                return false;
            }
            TaskLevel3 other = (TaskLevel3)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$requestBase64 = this.getRequestBase64();
            String other$requestBase64 = other.getRequestBase64();
            if (this$requestBase64 == null ? other$requestBase64 != null : !this$requestBase64.equals(other$requestBase64)) {
                return false;
            }
            SignedSignRequestDto this$signedSignRequest = this.getSignedSignRequest();
            SignedSignRequestDto other$signedSignRequest = other.getSignedSignRequest();
            if (this$signedSignRequest == null ? other$signedSignRequest != null : !this$signedSignRequest.equals(other$signedSignRequest)) {
                return false;
            }
            SignedModifyKeyRequestDto this$signedModifyKeyRequest = this.getSignedModifyKeyRequest();
            SignedModifyKeyRequestDto other$signedModifyKeyRequest = other.getSignedModifyKeyRequest();
            if (this$signedModifyKeyRequest == null ? other$signedModifyKeyRequest != null : !this$signedModifyKeyRequest.equals(other$signedModifyKeyRequest)) {
                return false;
            }
            SignedBlockKeyRequestDto this$signedBlockKeyRequest = this.getSignedBlockKeyRequest();
            SignedBlockKeyRequestDto other$signedBlockKeyRequest = other.getSignedBlockKeyRequest();
            if (this$signedBlockKeyRequest == null ? other$signedBlockKeyRequest != null : !this$signedBlockKeyRequest.equals(other$signedBlockKeyRequest)) {
                return false;
            }
            SignedUnblockKeyRequestDto this$signedUnblockKeyRequest = this.getSignedUnblockKeyRequest();
            SignedUnblockKeyRequestDto other$signedUnblockKeyRequest = other.getSignedUnblockKeyRequest();
            if (this$signedUnblockKeyRequest == null ? other$signedUnblockKeyRequest != null : !this$signedUnblockKeyRequest.equals(other$signedUnblockKeyRequest)) {
                return false;
            }
            SignedDecryptRequestDto this$signedDecryptRequest = this.getSignedDecryptRequest();
            SignedDecryptRequestDto other$signedDecryptRequest = other.getSignedDecryptRequest();
            if (this$signedDecryptRequest == null ? other$signedDecryptRequest != null : !this$signedDecryptRequest.equals(other$signedDecryptRequest)) {
                return false;
            }
            SignedUnwrapKeyRequestDto this$signedUnwrapKeyRequest = this.getSignedUnwrapKeyRequest();
            SignedUnwrapKeyRequestDto other$signedUnwrapKeyRequest = other.getSignedUnwrapKeyRequest();
            if (this$signedUnwrapKeyRequest == null ? other$signedUnwrapKeyRequest != null : !this$signedUnwrapKeyRequest.equals(other$signedUnwrapKeyRequest)) {
                return false;
            }
            SignedCertificateRequestRequestDto this$signedCertificateRequestRequest = this.getSignedCertificateRequestRequest();
            SignedCertificateRequestRequestDto other$signedCertificateRequestRequest = other.getSignedCertificateRequestRequest();
            if (this$signedCertificateRequestRequest == null ? other$signedCertificateRequestRequest != null : !((Object)this$signedCertificateRequestRequest).equals(other$signedCertificateRequestRequest)) {
                return false;
            }
            SignedSignCertificateRequestDto this$signedSignCertificateRequest = this.getSignedSignCertificateRequest();
            SignedSignCertificateRequestDto other$signedSignCertificateRequest = other.getSignedSignCertificateRequest();
            if (this$signedSignCertificateRequest == null ? other$signedSignCertificateRequest != null : !((Object)this$signedSignCertificateRequest).equals(other$signedSignCertificateRequest)) {
                return false;
            }
            SignedSelfSignCertificateRequestDto this$signedSelfSignCertificateRequestDto = this.getSignedSelfSignCertificateRequestDto();
            SignedSelfSignCertificateRequestDto other$signedSelfSignCertificateRequestDto = other.getSignedSelfSignCertificateRequestDto();
            return !(this$signedSelfSignCertificateRequestDto == null ? other$signedSelfSignCertificateRequestDto != null : !((Object)this$signedSelfSignCertificateRequestDto).equals(other$signedSelfSignCertificateRequestDto));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TaskLevel3;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $requestBase64 = this.getRequestBase64();
            result = result * 59 + ($requestBase64 == null ? 43 : $requestBase64.hashCode());
            SignedSignRequestDto $signedSignRequest = this.getSignedSignRequest();
            result = result * 59 + ($signedSignRequest == null ? 43 : $signedSignRequest.hashCode());
            SignedModifyKeyRequestDto $signedModifyKeyRequest = this.getSignedModifyKeyRequest();
            result = result * 59 + ($signedModifyKeyRequest == null ? 43 : $signedModifyKeyRequest.hashCode());
            SignedBlockKeyRequestDto $signedBlockKeyRequest = this.getSignedBlockKeyRequest();
            result = result * 59 + ($signedBlockKeyRequest == null ? 43 : $signedBlockKeyRequest.hashCode());
            SignedUnblockKeyRequestDto $signedUnblockKeyRequest = this.getSignedUnblockKeyRequest();
            result = result * 59 + ($signedUnblockKeyRequest == null ? 43 : $signedUnblockKeyRequest.hashCode());
            SignedDecryptRequestDto $signedDecryptRequest = this.getSignedDecryptRequest();
            result = result * 59 + ($signedDecryptRequest == null ? 43 : $signedDecryptRequest.hashCode());
            SignedUnwrapKeyRequestDto $signedUnwrapKeyRequest = this.getSignedUnwrapKeyRequest();
            result = result * 59 + ($signedUnwrapKeyRequest == null ? 43 : $signedUnwrapKeyRequest.hashCode());
            SignedCertificateRequestRequestDto $signedCertificateRequestRequest = this.getSignedCertificateRequestRequest();
            result = result * 59 + ($signedCertificateRequestRequest == null ? 43 : ((Object)$signedCertificateRequestRequest).hashCode());
            SignedSignCertificateRequestDto $signedSignCertificateRequest = this.getSignedSignCertificateRequest();
            result = result * 59 + ($signedSignCertificateRequest == null ? 43 : ((Object)$signedSignCertificateRequest).hashCode());
            SignedSelfSignCertificateRequestDto $signedSelfSignCertificateRequestDto = this.getSignedSelfSignCertificateRequestDto();
            result = result * 59 + ($signedSelfSignCertificateRequestDto == null ? 43 : ((Object)$signedSelfSignCertificateRequestDto).hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "GetTasksResponseDto.TaskLevel3(super=" + super.toString() + ", requestBase64=" + this.getRequestBase64() + ", signedSignRequest=" + this.getSignedSignRequest() + ", signedModifyKeyRequest=" + this.getSignedModifyKeyRequest() + ", signedBlockKeyRequest=" + this.getSignedBlockKeyRequest() + ", signedUnblockKeyRequest=" + this.getSignedUnblockKeyRequest() + ", signedDecryptRequest=" + this.getSignedDecryptRequest() + ", signedUnwrapKeyRequest=" + this.getSignedUnwrapKeyRequest() + ", signedCertificateRequestRequest=" + this.getSignedCertificateRequestRequest() + ", signedSignCertificateRequest=" + this.getSignedSignCertificateRequest() + ", signedSelfSignCertificateRequestDto=" + this.getSignedSelfSignCertificateRequestDto() + ")";
        }
    }

    @Schema(description="Task with detail level 2.")
    public static class TaskLevel2
    extends TaskLevel1 {
        @Schema(description="Additional meta data (base64 encoded) as provided by the sign requester.", format="byte")
        private String metaData;
        @Schema(description="Signature for the meta data (base64 encoded).", format="byte")
        private String metaDataSignature;
        @Schema(description="Payload (base64 encoded) that shall be signed.", format="byte")
        private String payload;
        @Schema(description="The type of the payload.")
        private PayloadType payloadType;

        public String getMetaData() {
            return this.metaData;
        }

        public String getMetaDataSignature() {
            return this.metaDataSignature;
        }

        public String getPayload() {
            return this.payload;
        }

        public PayloadType getPayloadType() {
            return this.payloadType;
        }

        public void setMetaData(String metaData) {
            this.metaData = metaData;
        }

        public void setMetaDataSignature(String metaDataSignature) {
            this.metaDataSignature = metaDataSignature;
        }

        public void setPayload(String payload) {
            this.payload = payload;
        }

        public void setPayloadType(PayloadType payloadType) {
            this.payloadType = payloadType;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskLevel2)) {
                return false;
            }
            TaskLevel2 other = (TaskLevel2)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$metaData = this.getMetaData();
            String other$metaData = other.getMetaData();
            if (this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData)) {
                return false;
            }
            String this$metaDataSignature = this.getMetaDataSignature();
            String other$metaDataSignature = other.getMetaDataSignature();
            if (this$metaDataSignature == null ? other$metaDataSignature != null : !this$metaDataSignature.equals(other$metaDataSignature)) {
                return false;
            }
            String this$payload = this.getPayload();
            String other$payload = other.getPayload();
            if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
                return false;
            }
            PayloadType this$payloadType = this.getPayloadType();
            PayloadType other$payloadType = other.getPayloadType();
            return !(this$payloadType == null ? other$payloadType != null : !((Object)((Object)this$payloadType)).equals((Object)other$payloadType));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TaskLevel2;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $metaData = this.getMetaData();
            result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
            String $metaDataSignature = this.getMetaDataSignature();
            result = result * 59 + ($metaDataSignature == null ? 43 : $metaDataSignature.hashCode());
            String $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            PayloadType $payloadType = this.getPayloadType();
            result = result * 59 + ($payloadType == null ? 43 : ((Object)((Object)$payloadType)).hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "GetTasksResponseDto.TaskLevel2(super=" + super.toString() + ", metaData=" + this.getMetaData() + ", metaDataSignature=" + this.getMetaDataSignature() + ", payload=" + this.getPayload() + ", payloadType=" + this.getPayloadType() + ")";
        }
    }

    @Schema(description="Task with detail level 1.")
    public static class TaskLevel1
    extends TaskLevel {
        @Schema(description="Already prepared ready to sign serialization of the approval token. The approvalToBeSigned is a binary structure with the following format.<br><br>Example:<br>Base64: /AAAADsABAABAAAAAhApAFRFU1RLRVkyMDIwLTAzLTE2XzEwLTQxLTA2LjM4NDY2MDA0MzcxMDAwAAAAVBBEAEAAAABXEBYAQXBwcm92ZVNpZ25UYXNrUGF5bG9hZAAABwEIALRJb14AAAAAAhASAHRlc3QtdGltZXN0YW1wLWtleQAAVhBbADBZMAwGCCqGSM49BAMCBQADSQAwRgIhAKLnz8NtSThbVkSMjj8Zwl45vmyQ4bL/XMbLxV0RYa5mAiEAudcZnBwJ8SAXvTpcgvbP4wPbID8/Ia+vmcoRqAlXjlkAVxAWAEFwcHJvdmVTaWduVGFza1BheWxvYWQAAA==<br>Hex: FC0000003B0004000100000002102900544553544B4559323032302D30332D31365F31302D34312D30362E3338343636303034333731303030000000541044004000000057101600417070726F76655369676E5461736B5061796C6F6164000007010800B4496F5E0000000002101200746573742D74696D657374616D702D6B6579000056105B003059300C06082A8648CE3D04030205000349003046022100A2E7CFC36D49385B56448C8E3F19C25E39BE6C90E1B2FF5CC6CBC55D1161AE66022100B9D7199C1C09F12017BD3A5C82F6CFE303DB203F3F21AFAF99CA11A809578E590057101600417070726F76655369676E5461736B5061796C6F61640000<br><br>FC000000<br><i>length: 252byte</i><br><br>3B00<br><i>type: 59d = EkaOperation</i><br><br>0400<br><i>length: = 4byte</i><br><br>01000000<br><i>data: Operation Type: \"OPERATION\", could also be \"BLOCK\", \"UNBLOCK\" or \"MODIFY\"</i><br><br>0210<br><i>type: 4098d = LabelUtf8String</i><br><br>2900<br><i>length: 41byte</i><br><br>544553544B4559323032302D30332D31365F31302D34312D30362E3338343636303034333731303030000000<br><i>data: label of the key = \"TESTKEY2020-03-16_10-41-06.38466004371000\" (incl. padding for 4byte alignment)</i><br><br>5410<br><i>type: 4180d = EkaTimeStamp</i><br><br>4400<br><i>length: 68byte</i><br><br>4000000057101600417070726F76655369676E5461736B5061796C6F6164000007010800B4496F5E0000000002101200746573742D74696D657374616D702D6B65790000<br><i>data: timestamp (see TaskLevel4 for details)</i><br><br>5610<br><i>type: 4182d = DerSignature</i><br><br>5B00<br><i>length: 91byte</i><br><br>3059300C06082A8648CE3D04030205000349003046022100A2E7CFC36D49385B56448C8E3F19C25E39BE6C90E1B2FF5CC6CBC55D1161AE66022100B9D7199C1C09F12017BD3A5C82F6CFE303DB203F3F21AFAF99CA11A809578E5900<i><br>data: signature of the timestamp (see TaskLevel4 for details)</i><br><br>5710<br><i>type: 4183d = EkaSignPayload (could also be EkaModifyPayload)</i><br><br>1600<br><i>length: 22bytes</i><br><br>417070726F76655369676E5461736B5061796C6F61640000<br><i>data: the payload to be signed</i>", format="base64")
        private String approvalToBeSigned;
        @Schema(description="The public key of the approver for whom the task was created.")
        private String approverPublicKey;

        public String getApprovalToBeSigned() {
            return this.approvalToBeSigned;
        }

        public String getApproverPublicKey() {
            return this.approverPublicKey;
        }

        public void setApprovalToBeSigned(String approvalToBeSigned) {
            this.approvalToBeSigned = approvalToBeSigned;
        }

        public void setApproverPublicKey(String approverPublicKey) {
            this.approverPublicKey = approverPublicKey;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskLevel1)) {
                return false;
            }
            TaskLevel1 other = (TaskLevel1)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$approvalToBeSigned = this.getApprovalToBeSigned();
            String other$approvalToBeSigned = other.getApprovalToBeSigned();
            if (this$approvalToBeSigned == null ? other$approvalToBeSigned != null : !this$approvalToBeSigned.equals(other$approvalToBeSigned)) {
                return false;
            }
            String this$approverPublicKey = this.getApproverPublicKey();
            String other$approverPublicKey = other.getApproverPublicKey();
            return !(this$approverPublicKey == null ? other$approverPublicKey != null : !this$approverPublicKey.equals(other$approverPublicKey));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TaskLevel1;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $approvalToBeSigned = this.getApprovalToBeSigned();
            result = result * 59 + ($approvalToBeSigned == null ? 43 : $approvalToBeSigned.hashCode());
            String $approverPublicKey = this.getApproverPublicKey();
            result = result * 59 + ($approverPublicKey == null ? 43 : $approverPublicKey.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "GetTasksResponseDto.TaskLevel1(super=" + super.toString() + ", approvalToBeSigned=" + this.getApprovalToBeSigned() + ", approverPublicKey=" + this.getApproverPublicKey() + ")";
        }
    }

    @Schema(description="Base Task Object")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="detailLevel", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TaskLevel1.class, name="level1"), @JsonSubTypes.Type(value=TaskLevel2.class, name="level2"), @JsonSubTypes.Type(value=TaskLevel3.class, name="level3"), @JsonSubTypes.Type(value=TaskLevel4.class, name="level4"), @JsonSubTypes.Type(value=TaskLevel5.class, name="level5"), @JsonSubTypes.Type(value=TaskLevel6.class, name="level6")})
    @JsonIgnoreProperties(value={"detailLevel"})
    public static class TaskLevel {
        @Schema(description="Id of the task.")
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskLevel)) {
                return false;
            }
            TaskLevel other = (TaskLevel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaskLevel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "GetTasksResponseDto.TaskLevel(id=" + this.getId() + ")";
        }
    }
}

