/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.response;

import com.securosys.tee.enums.tsb.RequestStatus;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="Response containing information about the status of a request.")
public class RequestStatusDto {
    @Schema(description="The id of the request.")
    private String id;
    @Schema(description="The current status of the request.")
    private RequestStatus status;
    @Schema(description="Date and time when the request is sent to the hsm in ISO-8601 format.", nullable=true)
    private String executionTime;
    @ArraySchema(schema=@Schema(description="Public keys of approvers that have approved the request."))
    private List<String> approvedBy;
    @ArraySchema(schema=@Schema(description="Public keys of approvers that have not yet approved the request but still could approve."))
    private List<String> notYetApprovedBy;
    @ArraySchema(schema=@Schema(description="Public keys from approvers that have rejected to approve the request (i.e. they deleted the task related to this request."))
    private List<String> rejectedBy;
    @Schema(description="The result of the request after the request was executed on the hsm. In case of a sign request this field contains the signature. In case of a decrypt request it contains the decrypted payload. Otherwise this field is empty.", nullable=true)
    private String result;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(RequestStatus status) {
        this.status = status;
    }

    public String getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(String executionTime) {
        this.executionTime = executionTime;
    }

    public List<String> getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(List<String> approvedBy) {
        this.approvedBy = approvedBy;
    }

    public List<String> getNotYetApprovedBy() {
        return this.notYetApprovedBy;
    }

    public void setNotYetApprovedBy(List<String> notYetApprovedBy) {
        this.notYetApprovedBy = notYetApprovedBy;
    }

    public List<String> getRejectedBy() {
        return this.rejectedBy;
    }

    public void setRejectedBy(List<String> rejectedBy) {
        this.rejectedBy = rejectedBy;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String toString() {
        return "RequestStatusDto{id='" + this.id + "', status=" + this.status + ", executionTime='" + this.executionTime + "', approvedBy=" + this.approvedBy + ", notYetApprovedBy=" + this.notYetApprovedBy + ", rejectedBy=" + this.rejectedBy + ", result='" + this.result + "'}";
    }
}

