/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;

@Schema(description="Data object")
public class DataObjectDto {
    @Schema(description="The name of the data object.")
    @NotEmpty
    private String name;
    @Schema(description="The value (base64 encoded) of the data object. The maximum size of the value is 64 kilobytes.", format="base64")
    @Base64Encoded
    @NotEmpty
    private String value;
    private Attributes attributes;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @Schema(description="The attributes of a data object.", name="DataObjectAttributes")
    public static class Attributes {
        @Schema(description="If true the data object is encrypted")
        @JsonProperty(value="private")
        private Boolean priv;
        @Schema(description="If true the data object can be modified.")
        private Boolean modifiable;
        @Schema(description="If true the data object can be deleted.")
        private Boolean destroyable;

        public Boolean getPriv() {
            return this.priv;
        }

        public void setPriv(Boolean priv) {
            this.priv = priv;
        }

        public Boolean getModifiable() {
            return this.modifiable;
        }

        public void setModifiable(Boolean modifiable) {
            this.modifiable = modifiable;
        }

        public Boolean getDestroyable() {
            return this.destroyable;
        }

        public void setDestroyable(Boolean destroyable) {
            this.destroyable = destroyable;
        }
    }
}

