/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.securosys.tee.dto.tsb.PolicyDto;
import com.securosys.tee.dto.tsb.request.AddressFormatDto;
import com.securosys.tee.dto.tsb.request.AttributesDto;
import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Schema(description="Import key request.")
public class ImportKeyDto {
    @NotEmpty
    @Schema(description="The name of the key.")
    private String label;
    @NotEmpty
    @Base64Encoded
    @Schema(description="The generated seed byte sequence between 128 and 512 bits; 256 bits is advised, from which the key is imported (base 64 encoded). Bits can be represented by a mnemonic phrase to write down.", format="byte")
    private String seed;
    @JacksonXmlProperty(localName="address_truncated")
    private AddressFormatDto addressFormat;
    @NotEmpty
    @Schema(description="The oid of the curve used for the EC algorithm.", example="1.3.132.0.10")
    private String curveOid;
    @NotNull
    @Valid
    private AttributesDto attributes;
    @Valid
    private PolicyDto policy;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getSeed() {
        return this.seed;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }

    public String getCurveOid() {
        return this.curveOid;
    }

    public void setCurveOid(String curveOid) {
        this.curveOid = curveOid;
    }

    public AttributesDto getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributesDto attributes) {
        this.attributes = attributes;
    }

    public PolicyDto getPolicy() {
        return this.policy;
    }

    public void setPolicy(PolicyDto policy) {
        this.policy = policy;
    }

    public AddressFormatDto getAddressFormat() {
        return this.addressFormat;
    }

    public void setAddressFormat(AddressFormatDto addressFormat) {
        this.addressFormat = addressFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportKeyDto that = (ImportKeyDto)o;
        return Objects.equals(this.label, that.label) && Objects.equals(this.seed, that.seed) && Objects.equals(this.curveOid, that.curveOid) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.policy, that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.seed, this.curveOid, this.attributes, this.policy);
    }

    public String toString() {
        return "ImportKeyDto{label='" + this.label + "', seed='*******', curveOid='" + this.curveOid + "', attributes=" + this.attributes + ", policy=" + this.policy + "}";
    }
}

