/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;

@Schema(description="Request to submit the authorization token of an approval client.")
public class SendApprovalDto {
    @Schema(description="Id of the task for which the approval is being submitted.")
    @NotEmpty
    private String id;
    @Schema(description="The approval token as received in the task or constructed by the client using additional data received in the task (base64 encoded)")
    @Base64Encoded
    @NotEmpty
    private String approvalToBeSigned;
    @Schema(description="The signature of the approvalToBeSigned received with the task (base64 encoded)")
    @Base64Encoded
    @NotEmpty
    private String signature;
    @Schema(description="The digest algorithm used for signing the approvalToBeSigned. The signature algorithm is given by the approver's private key", example="SHA-256", allowableValues={"SHA-224", "SHA-256", "SHA-384", "SHA-512", "SHA3-224", "SHA3-256", "SHA3-384", "SHA3-512"})
    @NotEmpty
    private String approvalDigestAlgorithm;
    @Schema(description="If approver is public key based: The public key of the approver in the same format as provided during key creation (base64 encoded)")
    @Base64Encoded
    private String approverPublicKey;
    @Schema(description="If approver is certificate based: The certificate of the approver in the same format as provided during key creation (base64 encoded)")
    @Base64Encoded
    private String approverCertificate;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApprovalToBeSigned() {
        return this.approvalToBeSigned;
    }

    public void setApprovalToBeSigned(String approvalToBeSigned) {
        this.approvalToBeSigned = approvalToBeSigned;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getApprovalDigestAlgorithm() {
        return this.approvalDigestAlgorithm;
    }

    public void setApprovalDigestAlgorithm(String approvalDigestAlgorithm) {
        this.approvalDigestAlgorithm = approvalDigestAlgorithm;
    }

    public String getApproverPublicKey() {
        return this.approverPublicKey;
    }

    public void setApproverPublicKey(String approverPublicKey) {
        this.approverPublicKey = approverPublicKey;
    }

    public String getApproverCertificate() {
        return this.approverCertificate;
    }

    public void setApproverCertificate(String approverCertificate) {
        this.approverCertificate = approverCertificate;
    }

    public String toString() {
        return "SendApprovalDto{id='" + this.id + "', approvalToBeSigned='" + this.approvalToBeSigned + "', signature='" + this.signature + "', approvalDigestAlgorithm='" + this.approvalDigestAlgorithm + "', approverPublicKey='" + this.approverPublicKey + "', approverCertificate='" + this.approverCertificate + "'}";
    }
}

