/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.enums.tsb.PayloadType;
import com.securosys.tee.enums.tsb.SignatureAlgorithm;
import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

@Schema(description="Sign request.")
public class SignRequestDto {
    @NotEmpty
    @Base64Encoded
    @Schema(description="Payload that shall be signed.", format="base64")
    private String payload;
    @Schema(description="The type of the payload.", defaultValue="UNSPECIFIED")
    private PayloadType payloadType = PayloadType.UNSPECIFIED;
    @NotEmpty
    @Schema(description="Name of the key with which the request shall be signed. Note: to create a sign request for a BIP32 derived key, make sure you have already created a master key that is BIP32 capable. Then use the master key name and add the derivation path (e.g. \"TESTKEY/0'/1'/2\").")
    private String signKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the sign key. If a derived key should be used for signing the key password of the master key must be specified."), schema=@Schema(pattern="^.{1}$"))
    private char[] keyPassword;
    @Base64Encoded
    @Schema(description="Additional meta data that will be provided to the approval client.", format="base64")
    private String metaData;
    @Base64Encoded
    @Schema(description="Signature for the meta data.", format="base64")
    private String metaDataSignature;
    @NotNull
    @Schema(description="The signature algorithm to be used. The chosen algorithm has to be compatible with the type of the key referenced by the signKeyName param.")
    private SignatureAlgorithm signatureAlgorithm;
    @Schema(description="The type of the signature result (default is DER), the rest-api can create V,R,S signature compatible with Ethereum. The result is in any case base64-encoded", example="DER", allowableValues={"ETH", "DER"})
    private String signatureType;
    @Base64Encoded
    @Schema(description="(Optional) Base64 encoded context bytes for ML-DSA & SLH-DSA, which is included in the message hash computation, provides domain seperation, binds signature to a specific use case (e.g., different protocols or applications, prevents cross-protocol attacks.", format="base64")
    private String context;
    @Schema(description="(Optional) NONE_WITH_EC_SCHNORR_BIP0340 only, specify 'auxiliaryRandomData' (base64, 32 raw bytes), if not specified, the HSM generates random aux_data", format="base64")
    @Base64Encoded
    private String auxiliaryRandomData;
    @Schema(description="(Optional) NONE_WITH_EC_SCHNORR_BIP0340 only, specify 'taprootTweakData' (base64, 32 raw bytes), used in signing with key-path, if specified 'merkleRootData' must be empty.", format="base64")
    @Base64Encoded
    private String taprootTweakData;
    @Schema(description="(Optional) NONE_WITH_EC_SCHNORR_BIP0340  only, specify 'merkleRootData', used in signing with script-path (multi-sig), if specified 'taprootTweakData' must be empty.", format="base64")
    @Base64Encoded
    private String merkleRootData;

    public String getPayload() {
        return this.payload;
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public String getSignKeyName() {
        return this.signKeyName;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String getMetaDataSignature() {
        return this.metaDataSignature;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getSignatureType() {
        return this.signatureType;
    }

    public String getContext() {
        return this.context;
    }

    public String getAuxiliaryRandomData() {
        return this.auxiliaryRandomData;
    }

    public String getTaprootTweakData() {
        return this.taprootTweakData;
    }

    public String getMerkleRootData() {
        return this.merkleRootData;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setPayloadType(PayloadType payloadType) {
        this.payloadType = payloadType;
    }

    public void setSignKeyName(String signKeyName) {
        this.signKeyName = signKeyName;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    public void setMetaDataSignature(String metaDataSignature) {
        this.metaDataSignature = metaDataSignature;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public void setSignatureType(String signatureType) {
        this.signatureType = signatureType;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setAuxiliaryRandomData(String auxiliaryRandomData) {
        this.auxiliaryRandomData = auxiliaryRandomData;
    }

    public void setTaprootTweakData(String taprootTweakData) {
        this.taprootTweakData = taprootTweakData;
    }

    public void setMerkleRootData(String merkleRootData) {
        this.merkleRootData = merkleRootData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignRequestDto)) {
            return false;
        }
        SignRequestDto other = (SignRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$payload = this.getPayload();
        String other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        PayloadType this$payloadType = this.getPayloadType();
        PayloadType other$payloadType = other.getPayloadType();
        if (this$payloadType == null ? other$payloadType != null : !((Object)((Object)this$payloadType)).equals((Object)other$payloadType)) {
            return false;
        }
        String this$signKeyName = this.getSignKeyName();
        String other$signKeyName = other.getSignKeyName();
        if (this$signKeyName == null ? other$signKeyName != null : !this$signKeyName.equals(other$signKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyPassword(), other.getKeyPassword())) {
            return false;
        }
        String this$metaData = this.getMetaData();
        String other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData)) {
            return false;
        }
        String this$metaDataSignature = this.getMetaDataSignature();
        String other$metaDataSignature = other.getMetaDataSignature();
        if (this$metaDataSignature == null ? other$metaDataSignature != null : !this$metaDataSignature.equals(other$metaDataSignature)) {
            return false;
        }
        SignatureAlgorithm this$signatureAlgorithm = this.getSignatureAlgorithm();
        SignatureAlgorithm other$signatureAlgorithm = other.getSignatureAlgorithm();
        if (this$signatureAlgorithm == null ? other$signatureAlgorithm != null : !((Object)((Object)this$signatureAlgorithm)).equals((Object)other$signatureAlgorithm)) {
            return false;
        }
        String this$signatureType = this.getSignatureType();
        String other$signatureType = other.getSignatureType();
        if (this$signatureType == null ? other$signatureType != null : !this$signatureType.equals(other$signatureType)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        String this$auxiliaryRandomData = this.getAuxiliaryRandomData();
        String other$auxiliaryRandomData = other.getAuxiliaryRandomData();
        if (this$auxiliaryRandomData == null ? other$auxiliaryRandomData != null : !this$auxiliaryRandomData.equals(other$auxiliaryRandomData)) {
            return false;
        }
        String this$taprootTweakData = this.getTaprootTweakData();
        String other$taprootTweakData = other.getTaprootTweakData();
        if (this$taprootTweakData == null ? other$taprootTweakData != null : !this$taprootTweakData.equals(other$taprootTweakData)) {
            return false;
        }
        String this$merkleRootData = this.getMerkleRootData();
        String other$merkleRootData = other.getMerkleRootData();
        return !(this$merkleRootData == null ? other$merkleRootData != null : !this$merkleRootData.equals(other$merkleRootData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SignRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        PayloadType $payloadType = this.getPayloadType();
        result = result * 59 + ($payloadType == null ? 43 : ((Object)((Object)$payloadType)).hashCode());
        String $signKeyName = this.getSignKeyName();
        result = result * 59 + ($signKeyName == null ? 43 : $signKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        String $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
        String $metaDataSignature = this.getMetaDataSignature();
        result = result * 59 + ($metaDataSignature == null ? 43 : $metaDataSignature.hashCode());
        SignatureAlgorithm $signatureAlgorithm = this.getSignatureAlgorithm();
        result = result * 59 + ($signatureAlgorithm == null ? 43 : ((Object)((Object)$signatureAlgorithm)).hashCode());
        String $signatureType = this.getSignatureType();
        result = result * 59 + ($signatureType == null ? 43 : $signatureType.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        String $auxiliaryRandomData = this.getAuxiliaryRandomData();
        result = result * 59 + ($auxiliaryRandomData == null ? 43 : $auxiliaryRandomData.hashCode());
        String $taprootTweakData = this.getTaprootTweakData();
        result = result * 59 + ($taprootTweakData == null ? 43 : $taprootTweakData.hashCode());
        String $merkleRootData = this.getMerkleRootData();
        result = result * 59 + ($merkleRootData == null ? 43 : $merkleRootData.hashCode());
        return result;
    }

    public String toString() {
        return "SignRequestDto(payload=" + this.getPayload() + ", payloadType=" + this.getPayloadType() + ", signKeyName=" + this.getSignKeyName() + ", keyPassword=" + Arrays.toString(this.getKeyPassword()) + ", metaData=" + this.getMetaData() + ", metaDataSignature=" + this.getMetaDataSignature() + ", signatureAlgorithm=" + this.getSignatureAlgorithm() + ", signatureType=" + this.getSignatureType() + ", context=" + this.getContext() + ", auxiliaryRandomData=" + this.getAuxiliaryRandomData() + ", taprootTweakData=" + this.getTaprootTweakData() + ", merkleRootData=" + this.getMerkleRootData() + ")";
    }
}

