/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Schema(description="Synchronous block key request. Only supports SKA keys.")
public class SynchronousBlockKeyRequestDto {
    @NotEmpty
    @Schema(description="Name of the key which shall be blocked.")
    private String blockKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the block key."), schema=@Schema(pattern="^.{1}$"))
    private char[] keyPassword;
    @ArraySchema(schema=@Schema(description="Signed approvals that are used to synchronously block with a SKA key. A single signed approval is a base64 encoded value that consists of the following components:\n1. The header containing the total size.\n2. The approvalToBeSigned which is the approval token that was signed by the approval client.\n3. The DER encoded signature of the token done by the approval client.\n4. The DER encoded public key of the approval client.", format="base64"))
    private List<@Base64Encoded String> signedApprovals = new ArrayList<String>();

    public String getBlockKeyName() {
        return this.blockKeyName;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public List<@Base64Encoded String> getSignedApprovals() {
        return this.signedApprovals;
    }

    public void setBlockKeyName(String blockKeyName) {
        this.blockKeyName = blockKeyName;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setSignedApprovals(List<@Base64Encoded String> signedApprovals) {
        this.signedApprovals = signedApprovals;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronousBlockKeyRequestDto)) {
            return false;
        }
        SynchronousBlockKeyRequestDto other = (SynchronousBlockKeyRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$blockKeyName = this.getBlockKeyName();
        String other$blockKeyName = other.getBlockKeyName();
        if (this$blockKeyName == null ? other$blockKeyName != null : !this$blockKeyName.equals(other$blockKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyPassword(), other.getKeyPassword())) {
            return false;
        }
        List<String> this$signedApprovals = this.getSignedApprovals();
        List<String> other$signedApprovals = other.getSignedApprovals();
        return !(this$signedApprovals == null ? other$signedApprovals != null : !((Object)this$signedApprovals).equals(other$signedApprovals));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SynchronousBlockKeyRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $blockKeyName = this.getBlockKeyName();
        result = result * 59 + ($blockKeyName == null ? 43 : $blockKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        List<String> $signedApprovals = this.getSignedApprovals();
        result = result * 59 + ($signedApprovals == null ? 43 : ((Object)$signedApprovals).hashCode());
        return result;
    }

    public String toString() {
        return "SynchronousBlockKeyRequestDto(blockKeyName=" + this.getBlockKeyName() + ", keyPassword=" + Arrays.toString(this.getKeyPassword()) + ", signedApprovals=" + this.getSignedApprovals() + ")";
    }
}

