/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.enums.tsb;

import com.securosys.tee.exceptions.tsb.BusinessException;
import com.securosys.tee.exceptions.tsb.BusinessReason;

public enum KeyUsage {
    DIGITAL_SIGNATURE("digitalSignature"),
    CONTENT_COMMITMENT("contentCommitment"),
    KEY_ENCIPHERMENT("keyEncipherment"),
    DATA_ENCIPHERMENT("dataEncipherment"),
    KEY_AGREEMENT("keyAgreement"),
    KEY_CERT_SIGN("keyCertSign"),
    CRL_SIGN("cRLSign"),
    ENCIPHER_ONLY("encipherOnly"),
    DECIPHER_ONLY("decipherOnly");

    private String keyUsage;

    private KeyUsage(String keyUsage) {
        this.keyUsage = keyUsage;
    }

    public static KeyUsage fromKeyUsageString(String keyUsage) {
        for (KeyUsage usage : KeyUsage.values()) {
            if (!usage.getKeyUsage().equalsIgnoreCase(keyUsage)) continue;
            return usage;
        }
        String msg = String.format("keyUsage='%s' can not be mapped to KeyUsage", keyUsage);
        throw new BusinessException(msg, BusinessReason.ERROR_INVALID_VALUE_FOR_ENUM);
    }

    public String getKeyUsage() {
        return this.keyUsage;
    }
}

