/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.enums.tsb;

import com.securosys.tee.exceptions.tsb.BusinessException;
import com.securosys.tee.exceptions.tsb.BusinessReason;

public enum KeytoolSignatureAlgorithm {
    SHA224_WITH_RSA("SHA224withRSA"),
    SHA256_WITH_RSA("SHA256withRSA"),
    SHA384_WITH_RSA("SHA384withRSA"),
    SHA512_WITH_RSA("SHA512withRSA"),
    SHA256_WITH_ECDSA("SHA256withECDSA"),
    SHA384_WITH_ECDSA("SHA384withECDSA"),
    SHA512_WITH_ECDSA("SHA512withECDSA");

    private String algorithm;

    private KeytoolSignatureAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public static KeytoolSignatureAlgorithm fromAlgorithm(String algorithm) {
        for (KeytoolSignatureAlgorithm signatureAlgorithm : KeytoolSignatureAlgorithm.values()) {
            if (!signatureAlgorithm.getAlgorithm().equalsIgnoreCase(algorithm)) continue;
            return signatureAlgorithm;
        }
        String msg = String.format("algorithm='%s' can not be mapped to SignatureAlgorithm", algorithm);
        throw new BusinessException(msg, BusinessReason.ERROR_INVALID_VALUE_FOR_ENUM);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

