/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.validation.tsb;

import com.securosys.tee.validation.tsb.ISO8601Timestamp;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

public class ISO8601TimestampValidator
implements ConstraintValidator<ISO8601Timestamp, String> {
    private static final Pattern timestampPattern = Pattern.compile("^^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d+|.{0})(?:Z|[+-][01]\\d:[0-5]\\d)$");

    @Override
    public void initialize(ISO8601Timestamp constraintAnnotation) {
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return timestampPattern.matcher(value).matches();
    }
}

