/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import com.securosys.tee.validation.tsb.DivisibleBy60;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;

@Schema(description="The new policy that shall be applied to a key. Contains the rules to use this key for signing a payloadin a sign request, the rules to block and unblock this key, and the rules to modify the policy of this key. If a rule is empty the associated operation can be performed without any approvals.")
public class ModifyPolicyDto {
    @Valid
    @JacksonXmlProperty(localName="rule_use")
    private Rule ruleUse;
    @Valid
    @JacksonXmlProperty(localName="rule_block")
    private Rule ruleBlock;
    @Valid
    @JacksonXmlProperty(localName="rule_unblock")
    private Rule ruleUnblock;
    @Valid
    @JacksonXmlProperty(localName="rule_modify")
    private Rule ruleModify;

    public Rule getRuleUse() {
        return this.ruleUse;
    }

    public void setRuleUse(Rule ruleUse) {
        this.ruleUse = ruleUse;
    }

    public Rule getRuleBlock() {
        return this.ruleBlock;
    }

    public void setRuleBlock(Rule ruleBlock) {
        this.ruleBlock = ruleBlock;
    }

    public Rule getRuleUnblock() {
        return this.ruleUnblock;
    }

    public void setRuleUnblock(Rule ruleUnblock) {
        this.ruleUnblock = ruleUnblock;
    }

    public Rule getRuleModify() {
        return this.ruleModify;
    }

    public void setRuleModify(Rule ruleModify) {
        this.ruleModify = ruleModify;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyPolicyDto that = (ModifyPolicyDto)o;
        return Objects.equals(this.ruleUse, that.ruleUse) && Objects.equals(this.ruleBlock, that.ruleBlock) && Objects.equals(this.ruleUnblock, that.ruleUnblock) && Objects.equals(this.ruleModify, that.ruleModify);
    }

    public int hashCode() {
        return Objects.hash(this.ruleUse, this.ruleBlock, this.ruleUnblock, this.ruleModify);
    }

    public String toString() {
        return "ModifyPolicyDto{ruleUse=" + this.ruleUse + ", ruleBlock=" + this.ruleBlock + ", ruleUnblock=" + this.ruleUnblock + ", ruleModify=" + this.ruleModify + "}";
    }

    @Schema(description="A rule contains multiple tokens. If all groups in a token reach their quorum of approvals the rule is fulfilled and the associated operation is performed on the HSM.")
    public static class Rule {
        @Valid
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="token")
        @NotNull
        @Schema(description="The list of tokens in the rule.")
        private List<Token> tokens;

        public List<Token> getTokens() {
            return this.tokens;
        }

        public void setTokens(List<Token> tokens) {
            this.tokens = tokens;
        }

        public String toString() {
            return "Rule{tokens=" + this.tokens + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule rule = (Rule)o;
            return Objects.equals(this.tokens, rule.tokens);
        }

        public int hashCode() {
            return Objects.hash(this.tokens);
        }
    }

    @Schema(description="Contains information about the approval client that can send an approval.")
    public static class Approval {
        @JacksonXmlProperty(isAttribute=true)
        @NotNull
        @Schema(description="The type of the approval.")
        private ApprovalType type;
        @JacksonXmlProperty(isAttribute=true)
        @Schema(description="The name of the approval. Only supported if type is 'public_key'. If type is 'certificate' the common name in the certificate is used as name.")
        private String name;
        @JacksonXmlText
        @NotEmpty
        @Schema(description="Either the public key if the type of the approval is public_key or a certificate (base64 encoded) if the type is certificate.")
        private String value;

        public ApprovalType getType() {
            return this.type;
        }

        public void setType(ApprovalType type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "Approval{type='" + this.type + "', name='" + this.name + "', value='" + this.value + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Approval approval = (Approval)o;
            return Objects.equals((Object)this.type, (Object)approval.type) && Objects.equals(this.name, approval.name) && Objects.equals(this.value, approval.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.name, this.value});
        }
    }

    @Schema(description="Contains a list of approvals. Approval clients in this list can approve the request to reach the quorum of the group.")
    public static class Group {
        @JacksonXmlProperty(isAttribute=true)
        @Schema(description="The name of the group.")
        private String name;
        @NotNull
        @Schema(description="The quorum of the group.")
        private Integer quorum;
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="approval")
        @NotNull
        @Schema(description="The list of approval clients that can send an approval.")
        private List<Approval> approvals;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getQuorum() {
            return this.quorum;
        }

        public void setQuorum(Integer quorum) {
            this.quorum = quorum;
        }

        public List<Approval> getApprovals() {
            return this.approvals;
        }

        public void setApprovals(List<Approval> approvals) {
            this.approvals = approvals;
        }

        public String toString() {
            return "Group{name='" + this.name + "', quorum=" + this.quorum + ", approvals=" + this.approvals + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return Objects.equals(this.name, group.name) && Objects.equals(this.quorum, group.quorum) && Objects.equals(this.approvals, group.approvals);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.quorum, this.approvals);
        }
    }

    @Schema(description="Contains multiple groups of approvals. A token is only valid for a specified time window. The time windows can be disabled by setting timelock and timeout to 0 which makes the token immediately active and never expiring.")
    public static class Token {
        @JacksonXmlProperty(isAttribute=true)
        @Schema(description="The name of the token.")
        private String name;
        @DivisibleBy60
        @NotNull
        @Schema(description="The amount of time in seconds after which the token is valid starting from the creation time of the request. The value must be a multiple of 60 as the seconds must represent full minutes. When the timelock is set to 0 the token is immediately active.")
        private Integer timelock;
        @DivisibleBy60
        @NotNull
        @Schema(description="The amount of time in seconds after which the token is no longer valid starting from the creation time of the request. The value must be a multiple of 60 as the seconds must represent full minutes. When the timeout is set to 0 the token is forever valid.")
        private Integer timeout;
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="group")
        @Schema(description="The list of groups in the token.", nullable=true)
        private List<Group> groups;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getTimelock() {
            return this.timelock;
        }

        public void setTimelock(Integer timelock) {
            this.timelock = timelock;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public List<Group> getGroups() {
            return this.groups;
        }

        public void setGroups(List<Group> groups) {
            this.groups = groups;
        }

        public String toString() {
            return "Token{name='" + this.name + "', timelock=" + this.timelock + ", timeout=" + this.timeout + ", groups=" + this.groups + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Token token = (Token)o;
            return Objects.equals(this.name, token.name) && Objects.equals(this.timelock, token.timelock) && Objects.equals(this.timeout, token.timeout) && Objects.equals(this.groups, token.groups);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.timelock, this.timeout, this.groups);
        }
    }

    public static enum ApprovalType {
        certificate,
        public_key;

    }
}

