/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;

@Schema(description="Block key request.")
public class BlockKeyRequestDto {
    @NotEmpty
    @Schema(description="Name of the key which shall be blocked.")
    private String blockKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the block key."), schema=@Schema(pattern="^.{1}$"))
    private char[] keyPassword;
    @Base64Encoded
    @Schema(description="Additional meta data (base64 encoded) that will be provided to the approval client.", format="byte")
    private String metaData;
    @Base64Encoded
    @Schema(description="Signature for the meta data (base64 encoded).", format="byte")
    private String metaDataSignature;

    public String getBlockKeyName() {
        return this.blockKeyName;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String getMetaDataSignature() {
        return this.metaDataSignature;
    }

    public void setBlockKeyName(String blockKeyName) {
        this.blockKeyName = blockKeyName;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    public void setMetaDataSignature(String metaDataSignature) {
        this.metaDataSignature = metaDataSignature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockKeyRequestDto)) {
            return false;
        }
        BlockKeyRequestDto other = (BlockKeyRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$blockKeyName = this.getBlockKeyName();
        String other$blockKeyName = other.getBlockKeyName();
        if (this$blockKeyName == null ? other$blockKeyName != null : !this$blockKeyName.equals(other$blockKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyPassword(), other.getKeyPassword())) {
            return false;
        }
        String this$metaData = this.getMetaData();
        String other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData)) {
            return false;
        }
        String this$metaDataSignature = this.getMetaDataSignature();
        String other$metaDataSignature = other.getMetaDataSignature();
        return !(this$metaDataSignature == null ? other$metaDataSignature != null : !this$metaDataSignature.equals(other$metaDataSignature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockKeyRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $blockKeyName = this.getBlockKeyName();
        result = result * 59 + ($blockKeyName == null ? 43 : $blockKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        String $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
        String $metaDataSignature = this.getMetaDataSignature();
        result = result * 59 + ($metaDataSignature == null ? 43 : $metaDataSignature.hashCode());
        return result;
    }

    public String toString() {
        return "BlockKeyRequestDto(blockKeyName=" + this.getBlockKeyName() + ", keyPassword=" + Arrays.toString(this.getKeyPassword()) + ", metaData=" + this.getMetaData() + ", metaDataSignature=" + this.getMetaDataSignature() + ")";
    }
}

