/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.securosys.tee.dto.tsb.PolicyDto;
import com.securosys.tee.dto.tsb.request.AddressFormatDto;
import com.securosys.tee.dto.tsb.request.AttributesDto;
import com.securosys.tee.validation.tsb.Base64Encoded;
import com.securosys.tee.validation.tsb.EmptyIfAnotherFieldHasValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;

@Schema(description="Key import request. For a symmetric key the privateKey and publicKey must be empty. For an asymmetric key the secretKey must be empty")
@EmptyIfAnotherFieldHasValue.List(value={@EmptyIfAnotherFieldHasValue(fieldName="privateKey", dependFieldName="secretKey"), @EmptyIfAnotherFieldHasValue(fieldName="publicKey", dependFieldName="secretKey"), @EmptyIfAnotherFieldHasValue(fieldName="certificate", dependFieldName="publicKey")})
public class KeyImportDto {
    @NotEmpty
    @Schema(description="The name of the key.")
    private String label;
    @NotEmpty
    @Schema(description="The key algorithm.")
    private String algorithm;
    @JacksonXmlProperty(localName="address_truncated")
    private AddressFormatDto addressFormat;
    @Base64Encoded
    @Schema(description="The private key to be imported. The key must be encoded in the DER format including information like the algorithm or the curve OID.", format="base64")
    private String privateKey;
    @Base64Encoded
    @Schema(description="The public key to be imported. The key must be encoded in the DER format including information like the algorithm or the curve OID.", format="base64")
    private String publicKey;
    @Base64Encoded
    @Schema(description="The secret key to be imported", format="base64")
    private String secretKey;
    @Base64Encoded
    @Schema(description="Certificate that should be set to the imported key", format="base64")
    private String certificate;
    @NotNull
    @Valid
    private AttributesDto attributes;
    @Valid
    private PolicyDto policy;

    public String getLabel() {
        return this.label;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public AddressFormatDto getAddressFormat() {
        return this.addressFormat;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public AttributesDto getAttributes() {
        return this.attributes;
    }

    public PolicyDto getPolicy() {
        return this.policy;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @JacksonXmlProperty(localName="address_truncated")
    public void setAddressFormat(AddressFormatDto addressFormat) {
        this.addressFormat = addressFormat;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public void setAttributes(AttributesDto attributes) {
        this.attributes = attributes;
    }

    public void setPolicy(PolicyDto policy) {
        this.policy = policy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyImportDto)) {
            return false;
        }
        KeyImportDto other = (KeyImportDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        AddressFormatDto this$addressFormat = this.getAddressFormat();
        AddressFormatDto other$addressFormat = other.getAddressFormat();
        if (this$addressFormat == null ? other$addressFormat != null : !((Object)this$addressFormat).equals(other$addressFormat)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$certificate = this.getCertificate();
        String other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !this$certificate.equals(other$certificate)) {
            return false;
        }
        AttributesDto this$attributes = this.getAttributes();
        AttributesDto other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        PolicyDto this$policy = this.getPolicy();
        PolicyDto other$policy = other.getPolicy();
        return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyImportDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        AddressFormatDto $addressFormat = this.getAddressFormat();
        result = result * 59 + ($addressFormat == null ? 43 : ((Object)$addressFormat).hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : $certificate.hashCode());
        AttributesDto $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        PolicyDto $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        return result;
    }

    public String toString() {
        return "KeyImportDto(label=" + this.getLabel() + ", algorithm=" + this.getAlgorithm() + ", addressFormat=" + this.getAddressFormat() + ", privateKey=" + this.getPrivateKey() + ", publicKey=" + this.getPublicKey() + ", secretKey=" + this.getSecretKey() + ", certificate=" + this.getCertificate() + ", attributes=" + this.getAttributes() + ", policy=" + this.getPolicy() + ")";
    }
}

