/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;

@JacksonXmlRootElement(localName="private_key")
@Schema(description="Key Label with password.")
public class KeyLabelWithPasswordDto {
    @NotEmpty
    @Schema(description="The name of the key. For derived keys (persisted in the HSM or only temporarily derived), append the full derivation path to the key name, e.g. MyKey/1/2/3.")
    private String label;
    @ArraySchema(arraySchema=@Schema(description="The password of the key"), schema=@Schema(pattern="^.{1}$"))
    private char[] password;

    public String getLabel() {
        return this.label;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyLabelWithPasswordDto)) {
            return false;
        }
        KeyLabelWithPasswordDto other = (KeyLabelWithPasswordDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        return Arrays.equals(this.getPassword(), other.getPassword());
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyLabelWithPasswordDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        return result;
    }

    public String toString() {
        return "KeyLabelWithPasswordDto(label=" + this.getLabel() + ", password=" + Arrays.toString(this.getPassword()) + ")";
    }
}

