/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;

@Schema(description="File decrypt request. Only supported by EC keys.")
public class SynchronousFileDecryptRequestDto {
    @NotEmpty
    @Schema(description="Name of the key with which the payload shall be decrypted.")
    private String decryptKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the decrypt key."), schema=@Schema(pattern="^.{1}$"))
    private char[] keyPassword;

    public String getDecryptKeyName() {
        return this.decryptKeyName;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public void setDecryptKeyName(String decryptKeyName) {
        this.decryptKeyName = decryptKeyName;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronousFileDecryptRequestDto)) {
            return false;
        }
        SynchronousFileDecryptRequestDto other = (SynchronousFileDecryptRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$decryptKeyName = this.getDecryptKeyName();
        String other$decryptKeyName = other.getDecryptKeyName();
        if (this$decryptKeyName == null ? other$decryptKeyName != null : !this$decryptKeyName.equals(other$decryptKeyName)) {
            return false;
        }
        return Arrays.equals(this.getKeyPassword(), other.getKeyPassword());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SynchronousFileDecryptRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $decryptKeyName = this.getDecryptKeyName();
        result = result * 59 + ($decryptKeyName == null ? 43 : $decryptKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        return result;
    }

    public String toString() {
        return "SynchronousFileDecryptRequestDto(decryptKeyName=" + this.getDecryptKeyName() + ", keyPassword=" + Arrays.toString(this.getKeyPassword()) + ")";
    }
}

