/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.dto.tsb.PolicyDto;
import com.securosys.tee.dto.tsb.request.AttributesDto;
import com.securosys.tee.enums.tsb.WrapMethod;
import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Schema(description="Synchronous unwrap key request.")
public class SynchronousUnwrapKeyRequestDto {
    @NotEmpty
    @Base64Encoded
    @Schema(description="The key (base64 encoded) that shall be unwrapped", format="base64")
    private String wrappedKey;
    @NotEmpty
    @Schema(description="The name of the key with which the unwrapped key shall be saved on the HSM")
    private String label;
    @NotNull
    @Valid
    private AttributesDto attributes;
    @NotEmpty
    @Schema(description="Name of the key with which the key shall be unwrapped.")
    private String unwrapKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the unwrap key."), schema=@Schema(pattern="^.{1}$"))
    private char[] unwrapKeyPassword;
    @NotNull
    @Schema(description="The wrap method to be used. The chosen method has to be compatible with the types of the referenced keys")
    private WrapMethod wrapMethod;
    @ArraySchema(schema=@Schema(description="Signed approvals that are used to synchronously unwrap with a SKA key. A single signed approval is a base64 encoded value that consists of the following components:\n1. The header containing the total size.\n2. The approvalToBeSigned which is the approval token that was signed by the approval client.\n3. The DER encoded signature of the token done by the approval client.\n4. The DER encoded public key of the approval client.", format="base64"))
    private List<@Base64Encoded String> signedApprovals = new ArrayList<String>();
    @Valid
    private PolicyDto policy;

    public String getWrappedKey() {
        return this.wrappedKey;
    }

    public String getLabel() {
        return this.label;
    }

    public AttributesDto getAttributes() {
        return this.attributes;
    }

    public String getUnwrapKeyName() {
        return this.unwrapKeyName;
    }

    public char[] getUnwrapKeyPassword() {
        return this.unwrapKeyPassword;
    }

    public WrapMethod getWrapMethod() {
        return this.wrapMethod;
    }

    public List<@Base64Encoded String> getSignedApprovals() {
        return this.signedApprovals;
    }

    public PolicyDto getPolicy() {
        return this.policy;
    }

    public void setWrappedKey(String wrappedKey) {
        this.wrappedKey = wrappedKey;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAttributes(AttributesDto attributes) {
        this.attributes = attributes;
    }

    public void setUnwrapKeyName(String unwrapKeyName) {
        this.unwrapKeyName = unwrapKeyName;
    }

    public void setUnwrapKeyPassword(char[] unwrapKeyPassword) {
        this.unwrapKeyPassword = unwrapKeyPassword;
    }

    public void setWrapMethod(WrapMethod wrapMethod) {
        this.wrapMethod = wrapMethod;
    }

    public void setSignedApprovals(List<@Base64Encoded String> signedApprovals) {
        this.signedApprovals = signedApprovals;
    }

    public void setPolicy(PolicyDto policy) {
        this.policy = policy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronousUnwrapKeyRequestDto)) {
            return false;
        }
        SynchronousUnwrapKeyRequestDto other = (SynchronousUnwrapKeyRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$wrappedKey = this.getWrappedKey();
        String other$wrappedKey = other.getWrappedKey();
        if (this$wrappedKey == null ? other$wrappedKey != null : !this$wrappedKey.equals(other$wrappedKey)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        AttributesDto this$attributes = this.getAttributes();
        AttributesDto other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$unwrapKeyName = this.getUnwrapKeyName();
        String other$unwrapKeyName = other.getUnwrapKeyName();
        if (this$unwrapKeyName == null ? other$unwrapKeyName != null : !this$unwrapKeyName.equals(other$unwrapKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getUnwrapKeyPassword(), other.getUnwrapKeyPassword())) {
            return false;
        }
        WrapMethod this$wrapMethod = this.getWrapMethod();
        WrapMethod other$wrapMethod = other.getWrapMethod();
        if (this$wrapMethod == null ? other$wrapMethod != null : !((Object)((Object)this$wrapMethod)).equals((Object)other$wrapMethod)) {
            return false;
        }
        List<String> this$signedApprovals = this.getSignedApprovals();
        List<String> other$signedApprovals = other.getSignedApprovals();
        if (this$signedApprovals == null ? other$signedApprovals != null : !((Object)this$signedApprovals).equals(other$signedApprovals)) {
            return false;
        }
        PolicyDto this$policy = this.getPolicy();
        PolicyDto other$policy = other.getPolicy();
        return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SynchronousUnwrapKeyRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $wrappedKey = this.getWrappedKey();
        result = result * 59 + ($wrappedKey == null ? 43 : $wrappedKey.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        AttributesDto $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $unwrapKeyName = this.getUnwrapKeyName();
        result = result * 59 + ($unwrapKeyName == null ? 43 : $unwrapKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getUnwrapKeyPassword());
        WrapMethod $wrapMethod = this.getWrapMethod();
        result = result * 59 + ($wrapMethod == null ? 43 : ((Object)((Object)$wrapMethod)).hashCode());
        List<String> $signedApprovals = this.getSignedApprovals();
        result = result * 59 + ($signedApprovals == null ? 43 : ((Object)$signedApprovals).hashCode());
        PolicyDto $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        return result;
    }

    public String toString() {
        return "SynchronousUnwrapKeyRequestDto(wrappedKey=" + this.getWrappedKey() + ", label=" + this.getLabel() + ", attributes=" + this.getAttributes() + ", unwrapKeyName=" + this.getUnwrapKeyName() + ", unwrapKeyPassword=" + Arrays.toString(this.getUnwrapKeyPassword()) + ", wrapMethod=" + this.getWrapMethod() + ", signedApprovals=" + this.getSignedApprovals() + ", policy=" + this.getPolicy() + ")";
    }
}

