/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.enums.tsb.SignatureAlgorithm;
import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;

@Schema(description="Verify signature request.")
public class VerifySignatureRequestDto {
    @NotEmpty
    @Schema(description="Name of the key with which the payload was signed. For signature verification of a derived key, append the full derivation path to the key name, e.g. MyKey/1/2/3.")
    private String signKeyName;
    @Base64Encoded
    @Schema(description="External key object with which the request shall be verified. Subscription for External Keystore required.", format="base64")
    private String signKeyObject;
    @ArraySchema(arraySchema=@Schema(description="The password of the master key, if the master key has a password set."), schema=@Schema(pattern="^.{1}$"))
    private char[] masterKeyPassword;
    @NotNull
    @Schema(description="The signature algorithm that was used to sign the payload.")
    private SignatureAlgorithm signatureAlgorithm;
    @NotEmpty
    @Base64Encoded
    @Schema(description="Payload (base64 encoded) for which the signature was created.", format="byte")
    private String payload;
    @NotEmpty
    @Base64Encoded
    @Schema(description="The signature to be verified.", format="byte")
    private String signature;

    public String getSignKeyName() {
        return this.signKeyName;
    }

    public void setSignKeyName(String signKeyName) {
        this.signKeyName = signKeyName;
    }

    public String getSignKeyObject() {
        return this.signKeyObject;
    }

    public void setSignKeyObject(String signKeyObject) {
        this.signKeyObject = signKeyObject;
    }

    public char[] getMasterKeyPassword() {
        return this.masterKeyPassword;
    }

    public void setMasterKeyPassword(char[] masterKeyPassword) {
        this.masterKeyPassword = masterKeyPassword;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}

