/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.enums.tsb;

import com.securosys.tee.exceptions.tsb.BusinessException;
import com.securosys.tee.exceptions.tsb.BusinessReason;

public enum ExtendedKeyUsage {
    ANY_EXTENDED_KEY_USAGE("anyExtendedKeyUsage"),
    SERVER_AUTH("serverAuth"),
    CLIENT_AUTH("clientAuth"),
    CODE_SIGNING("codeSigning"),
    EMAIL_PROTECTION("emailProtection"),
    TIME_STAMPING("timeStamping"),
    OCSP_SIGNING("OCSPSigning");

    private String extKeyUsage;

    private ExtendedKeyUsage(String extKeyUsage) {
        this.extKeyUsage = extKeyUsage;
    }

    public static ExtendedKeyUsage fromExtKeyUsageString(String extKeyUsage) {
        for (ExtendedKeyUsage usage : ExtendedKeyUsage.values()) {
            if (!usage.getExtKeyUsage().equalsIgnoreCase(extKeyUsage)) continue;
            return usage;
        }
        String msg = String.format("extendedKeyUsage='%s' can not be mapped to KeyUsage", extKeyUsage);
        throw new BusinessException(msg, BusinessReason.ERROR_INVALID_VALUE_FOR_ENUM);
    }

    public String getExtKeyUsage() {
        return this.extKeyUsage;
    }
}

