/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.exceptions.tsb;

import com.securosys.tee.exceptions.tsb.Reason;
import java.util.UUID;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReasonBasedException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReasonBasedException.class);
    private final String id;
    private final Reason reason;

    ReasonBasedException(String message, Reason reason, Throwable cause) {
        super(message, cause);
        this.reason = reason;
        if (cause instanceof ReasonBasedException) {
            ReasonBasedException businessException = (ReasonBasedException)cause;
            this.id = businessException.getId();
        } else {
            this.id = this.generateErrorId();
            LOGGER.info("caused by:", cause);
        }
    }

    ReasonBasedException(String message, Reason reason) {
        super(message);
        this.reason = reason;
        this.id = this.generateErrorId();
    }

    private static String whereAmI() {
        int maxDepth = 6;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StringBuilder msg = new StringBuilder();
        int depth = Math.min(stack.length, maxDepth);
        for (int currentDepth = 0; currentDepth < depth; ++currentDepth) {
            StackTraceElement currentStack = stack[currentDepth];
            Object fileName = currentStack.getFileName();
            fileName = fileName == null ? "Unknown Source" : (String)fileName + ":" + currentStack.getLineNumber();
            msg.append(currentStack.getClassName()).append(".").append(currentStack.getMethodName()).append("(").append((String)fileName).append(") ");
        }
        return msg.toString();
    }

    public Reason getReason() {
        return this.reason;
    }

    public String getId() {
        return this.id;
    }

    public int getErrorCode() {
        return this.reason.getErrorCode();
    }

    private String generateErrorId() {
        String tid = UUID.randomUUID().toString();
        String stackTrace = ReasonBasedException.whereAmI();
        String stringForIdGeneration = this.toStringForIdGeneration(tid);
        LOGGER.info(stringForIdGeneration);
        LOGGER.info("at {}", (Object)stackTrace);
        return tid;
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        tsb.append("id", this.id);
        tsb.append("reason", this.reason);
        tsb.append("message", this.getMessage());
        return tsb.toString();
    }

    private String toStringForIdGeneration(String tid) {
        ToStringBuilder tsb = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        tsb.append("id", tid);
        tsb.append("reason", this.reason);
        tsb.append("message", this.getMessage());
        return tsb.toString();
    }
}

