/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.securosys.tee.dto.JvmInput;
import com.securosys.tee.dto.request.Task;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;

public class RuleBasedBtcTransactionSigningExecutable {
    public static void main(String[] args) throws IOException {
        String input = new String(System.in.readAllBytes(), StandardCharsets.UTF_8);
        ObjectMapper mapper = new ObjectMapper();
        JvmInput jvmInput = mapper.readValue(input, JvmInput.class);
        try {
            Task.TaskLevel6 taskLevel = mapper.readValue(jvmInput.getInput(), Task.TaskLevel6.class);
            if (taskLevel.getApprovalToBeSigned() == null || taskLevel.getApprovalToBeSigned().isEmpty()) {
                throw new RuntimeException("ApprovalToBeSigned is not found in input");
            }
            String approvalToBeSigned = taskLevel.getApprovalToBeSigned();
            String base64Metadata = taskLevel.getMetaData();
            byte[] metadata = Base64.getDecoder().decode(base64Metadata.getBytes());
            if (metadata == null) {
                throw new RuntimeException("Input is invalid: Metadata is missing or empty.");
            }
            JsonNode metadataNode = mapper.readTree(metadata);
            JsonNode txHexNode = metadataNode.get("Unsigned Transaction Hex");
            if (txHexNode == null || txHexNode.isNull() || !txHexNode.isTextual()) {
                throw new RuntimeException("Input is invalid: 'Unsigned Transaction Hex' field is missing or not text in metadata.");
            }
            String unsignedTxHex = txHexNode.asText();
            List<TxOut> outputs = RuleBasedBtcTransactionSigningExecutable.parseTransactionOutputs(RuleBasedBtcTransactionSigningExecutable.hexToBytes(unsignedTxHex));
            Optional firstOutput = outputs.stream().findFirst();
            if (!firstOutput.isPresent()) {
                throw new RuntimeException("Full Transaction Input is invalid: no amount to spend declared");
            }
            TxOut amountToSpend = (TxOut)firstOutput.get();
            if (amountToSpend.value > 700L) {
                String reason = "REJECTED Extracted Amount (Satoshis) is: " + amountToSpend.value + ", limit exceeds treshhold.";
                System.out.write(reason.getBytes(StandardCharsets.UTF_8));
                System.out.flush();
                System.exit(0);
                return;
            }
            byte[] decodedApprovalToBeSigned = Base64.getDecoder().decode(approvalToBeSigned);
            System.out.write(decodedApprovalToBeSigned);
            System.out.flush();
            System.exit(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<TxOut> parseTransactionOutputs(byte[] rawTxBytes) {
        boolean isSegWit;
        ByteBuffer buffer = ByteBuffer.wrap(rawTxBytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ArrayList<TxOut> outputs = new ArrayList<TxOut>();
        buffer.getInt();
        boolean bl = isSegWit = buffer.get(buffer.position()) == 0 && buffer.get(buffer.position() + 1) == 1;
        if (isSegWit) {
            buffer.get();
            buffer.get();
        }
        long vinCount = RuleBasedBtcTransactionSigningExecutable.readVarInt(buffer);
        int i = 0;
        while ((long)i < vinCount) {
            buffer.position(buffer.position() + 36);
            long scriptSigLen = RuleBasedBtcTransactionSigningExecutable.readVarInt(buffer);
            buffer.position(buffer.position() + (int)scriptSigLen);
            buffer.getInt();
            ++i;
        }
        long voutCount = RuleBasedBtcTransactionSigningExecutable.readVarInt(buffer);
        int i2 = 0;
        while ((long)i2 < voutCount) {
            long value = buffer.getLong();
            long scriptPubKeyLen = RuleBasedBtcTransactionSigningExecutable.readVarInt(buffer);
            buffer.position(buffer.position() + (int)scriptPubKeyLen);
            outputs.add(new TxOut(value));
            ++i2;
        }
        return outputs;
    }

    public static int readVarInt(ByteBuffer buffer) {
        byte first = buffer.get();
        int value = first & 0xFF;
        if (value < 253) {
            return value;
        }
        if (value == 253) {
            return buffer.getShort() & 0xFFFF;
        }
        if (value == 254) {
            return buffer.getInt();
        }
        throw new IllegalArgumentException("8-byte VarInt for script length not supported/expected here.");
    }

    public static byte[] hexToBytes(String s2) {
        int len = s2.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s2.charAt(i), 16) << 4) + Character.digit(s2.charAt(i + 1), 16));
        }
        return data;
    }

    public static class TxOut {
        public final long value;

        public TxOut(long value) {
            this.value = value;
        }
    }
}

