/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.db;

import com.securosys.tee.db.DatabaseAdapter;
import com.securosys.tee.dto.DatabaseConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MariaDbDialectAdapter
implements DatabaseAdapter {
    private final DatabaseConnection connection;

    public MariaDbDialectAdapter(DatabaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public void saveState(String key, String value) {
        try (Connection conn = DriverManager.getConnection(this.connection.getUrl(), this.connection.getUsername(), this.connection.getPassword());){
            String sql = "INSERT INTO " + this.connection.getTable() + " (`key`, `value`) VALUES (?, ?) ON DUPLICATE KEY UPDATE `value` = VALUES(`value`)";
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, key);
                ps.setString(2, value);
                ps.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String readState(String key, String defaultValue) {
        try (Connection conn = DriverManager.getConnection(this.connection.getUrl(), this.connection.getUsername(), this.connection.getPassword());){
            String sql = "SELECT `value` FROM " + this.connection.getTable() + " WHERE `key` = ? FOR UPDATE";
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string2 = rs.getString("value");
                return string2;
            }
            String string = defaultValue;
            return string;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void deleteState(String key) {
        try (Connection conn = DriverManager.getConnection(this.connection.getUrl(), this.connection.getUsername(), this.connection.getPassword());){
            String sql = "DELETE FROM " + this.connection.getTable() + " WHERE `key`= ?";
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, key);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

