/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.util.Objects;

@Schema(description="Contains the crypto currency for which an address should be created. An address can only be created for keys with smart key attributes.")
public class AddressFormatDto {
    @JacksonXmlProperty(isAttribute=true)
    @NotEmpty
    @Schema(description="The crypto currency for which an address should be created.", allowableValues={"BTC", "ETH", "XLM", "XRP", "IOTA"})
    private String format;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String toString() {
        return "AddressTruncated{format='" + this.format + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressFormatDto that = (AddressFormatDto)o;
        return Objects.equals(this.format, that.format);
    }

    public int hashCode() {
        return Objects.hash(this.format);
    }
}

