/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

@Schema(description="Onboard approver request with name, backup password and a secret for AES_GCM transport encryption of the pkcs12-container.")
public class ApproverOnboardDto {
    @NotEmpty
    @NotNull
    @Schema(description="The name of the approver e.g. the e-mail address")
    private String approverName;
    @NotEmpty
    @NotNull
    @Schema(description="The OneTimeCode used to verify the approver.")
    private char[] oneTimeCode;
    @NotEmpty
    @NotNull
    @Schema(description="The transportPassword is a secret for AES_GCM transport encryption and is used to encrypt the pkcs12-container.")
    private char[] transportPassword;

    public String getApproverName() {
        return this.approverName;
    }

    public char[] getOneTimeCode() {
        return this.oneTimeCode;
    }

    public char[] getTransportPassword() {
        return this.transportPassword;
    }

    public void setApproverName(String approverName) {
        this.approverName = approverName;
    }

    public void setOneTimeCode(char[] oneTimeCode) {
        this.oneTimeCode = oneTimeCode;
    }

    public void setTransportPassword(char[] transportPassword) {
        this.transportPassword = transportPassword;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApproverOnboardDto)) {
            return false;
        }
        ApproverOnboardDto other = (ApproverOnboardDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$approverName = this.getApproverName();
        String other$approverName = other.getApproverName();
        if (this$approverName == null ? other$approverName != null : !this$approverName.equals(other$approverName)) {
            return false;
        }
        if (!Arrays.equals(this.getOneTimeCode(), other.getOneTimeCode())) {
            return false;
        }
        return Arrays.equals(this.getTransportPassword(), other.getTransportPassword());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApproverOnboardDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $approverName = this.getApproverName();
        result = result * 59 + ($approverName == null ? 43 : $approverName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getOneTimeCode());
        result = result * 59 + Arrays.hashCode(this.getTransportPassword());
        return result;
    }

    public String toString() {
        return "ApproverOnboardDto(approverName=" + this.getApproverName() + ", oneTimeCode=" + Arrays.toString(this.getOneTimeCode()) + ", transportPassword=" + Arrays.toString(this.getTransportPassword()) + ")";
    }
}

