/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;

@Schema(name="CreateKeyAttributes", description="The attributes of the key that should be created. At least one operation (decrypt, sign, unwrap) must be allowed (true).")
public class AttributesDto {
    @Schema(description="If true the key can be used to encrypt data. This attribute is only supported for symmetric keys.")
    private Boolean encrypt;
    @NotNull
    @Schema(description="If true the key can be used to decrypt data.")
    private Boolean decrypt;
    @Schema(description="This attribute is only supported for symmetric keys.")
    private Boolean verify;
    @NotNull
    @Schema(description="If true the key can sign.")
    private Boolean sign;
    @Schema(description="If true the key can be used to wrap another key. This attribute is only supported for symmetric keys.")
    private Boolean wrap;
    @NotNull
    @Schema(description="If true the key can be used to unwrap keys.")
    private Boolean unwrap;
    @Schema(description="If true it is possible to derive from this key.", defaultValue="false")
    private boolean derive = false;
    @Schema(description="If true the key derivation is done using BIP32. This option can only be true if the key's algorithm is EC or ED and the derive attribute is true.", defaultValue="false")
    private boolean bip32 = false;
    @Schema(description="If true the key is extractable. This option can only be true for keys without smart key attributes.", defaultValue="false")
    private boolean extractable = false;
    @Schema(description="If true the key can be modified. The 'modifiable' attribute applies exclusively to the key attribute and not to SKA-Policy.", defaultValue="true")
    private boolean modifiable = true;
    @Schema(description="If true the key can be deleted.", defaultValue="false")
    private boolean destroyable = false;
    @Schema(description="If true the key is sensitive. To export a key sensitive must be false")
    private Boolean sensitive;
    @Schema(description="If true the encrypted key can be stored in an external memory", defaultValue="false")
    private boolean copyable = false;

    public Boolean getEncrypt() {
        return this.encrypt;
    }

    public Boolean getDecrypt() {
        return this.decrypt;
    }

    public Boolean getVerify() {
        return this.verify;
    }

    public Boolean getSign() {
        return this.sign;
    }

    public Boolean getWrap() {
        return this.wrap;
    }

    public Boolean getUnwrap() {
        return this.unwrap;
    }

    public boolean isDerive() {
        return this.derive;
    }

    public boolean isBip32() {
        return this.bip32;
    }

    public boolean isExtractable() {
        return this.extractable;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isDestroyable() {
        return this.destroyable;
    }

    public Boolean getSensitive() {
        return this.sensitive;
    }

    public boolean isCopyable() {
        return this.copyable;
    }

    public void setEncrypt(Boolean encrypt) {
        this.encrypt = encrypt;
    }

    public void setDecrypt(Boolean decrypt) {
        this.decrypt = decrypt;
    }

    public void setVerify(Boolean verify) {
        this.verify = verify;
    }

    public void setSign(Boolean sign) {
        this.sign = sign;
    }

    public void setWrap(Boolean wrap) {
        this.wrap = wrap;
    }

    public void setUnwrap(Boolean unwrap) {
        this.unwrap = unwrap;
    }

    public void setDerive(boolean derive) {
        this.derive = derive;
    }

    public void setBip32(boolean bip32) {
        this.bip32 = bip32;
    }

    public void setExtractable(boolean extractable) {
        this.extractable = extractable;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public void setDestroyable(boolean destroyable) {
        this.destroyable = destroyable;
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    public void setCopyable(boolean copyable) {
        this.copyable = copyable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributesDto)) {
            return false;
        }
        AttributesDto other = (AttributesDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDerive() != other.isDerive()) {
            return false;
        }
        if (this.isBip32() != other.isBip32()) {
            return false;
        }
        if (this.isExtractable() != other.isExtractable()) {
            return false;
        }
        if (this.isModifiable() != other.isModifiable()) {
            return false;
        }
        if (this.isDestroyable() != other.isDestroyable()) {
            return false;
        }
        if (this.isCopyable() != other.isCopyable()) {
            return false;
        }
        Boolean this$encrypt = this.getEncrypt();
        Boolean other$encrypt = other.getEncrypt();
        if (this$encrypt == null ? other$encrypt != null : !((Object)this$encrypt).equals(other$encrypt)) {
            return false;
        }
        Boolean this$decrypt = this.getDecrypt();
        Boolean other$decrypt = other.getDecrypt();
        if (this$decrypt == null ? other$decrypt != null : !((Object)this$decrypt).equals(other$decrypt)) {
            return false;
        }
        Boolean this$verify = this.getVerify();
        Boolean other$verify = other.getVerify();
        if (this$verify == null ? other$verify != null : !((Object)this$verify).equals(other$verify)) {
            return false;
        }
        Boolean this$sign = this.getSign();
        Boolean other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !((Object)this$sign).equals(other$sign)) {
            return false;
        }
        Boolean this$wrap = this.getWrap();
        Boolean other$wrap = other.getWrap();
        if (this$wrap == null ? other$wrap != null : !((Object)this$wrap).equals(other$wrap)) {
            return false;
        }
        Boolean this$unwrap = this.getUnwrap();
        Boolean other$unwrap = other.getUnwrap();
        if (this$unwrap == null ? other$unwrap != null : !((Object)this$unwrap).equals(other$unwrap)) {
            return false;
        }
        Boolean this$sensitive = this.getSensitive();
        Boolean other$sensitive = other.getSensitive();
        return !(this$sensitive == null ? other$sensitive != null : !((Object)this$sensitive).equals(other$sensitive));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributesDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDerive() ? 79 : 97);
        result = result * 59 + (this.isBip32() ? 79 : 97);
        result = result * 59 + (this.isExtractable() ? 79 : 97);
        result = result * 59 + (this.isModifiable() ? 79 : 97);
        result = result * 59 + (this.isDestroyable() ? 79 : 97);
        result = result * 59 + (this.isCopyable() ? 79 : 97);
        Boolean $encrypt = this.getEncrypt();
        result = result * 59 + ($encrypt == null ? 43 : ((Object)$encrypt).hashCode());
        Boolean $decrypt = this.getDecrypt();
        result = result * 59 + ($decrypt == null ? 43 : ((Object)$decrypt).hashCode());
        Boolean $verify = this.getVerify();
        result = result * 59 + ($verify == null ? 43 : ((Object)$verify).hashCode());
        Boolean $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : ((Object)$sign).hashCode());
        Boolean $wrap = this.getWrap();
        result = result * 59 + ($wrap == null ? 43 : ((Object)$wrap).hashCode());
        Boolean $unwrap = this.getUnwrap();
        result = result * 59 + ($unwrap == null ? 43 : ((Object)$unwrap).hashCode());
        Boolean $sensitive = this.getSensitive();
        result = result * 59 + ($sensitive == null ? 43 : ((Object)$sensitive).hashCode());
        return result;
    }

    public String toString() {
        return "AttributesDto(encrypt=" + this.getEncrypt() + ", decrypt=" + this.getDecrypt() + ", verify=" + this.getVerify() + ", sign=" + this.getSign() + ", wrap=" + this.getWrap() + ", unwrap=" + this.getUnwrap() + ", derive=" + this.isDerive() + ", bip32=" + this.isBip32() + ", extractable=" + this.isExtractable() + ", modifiable=" + this.isModifiable() + ", destroyable=" + this.isDestroyable() + ", sensitive=" + this.getSensitive() + ", copyable=" + this.isCopyable() + ")";
    }
}

