/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.enums.tsb.CipherAlgorithm;
import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

@Schema(description="Decrypt request. Only supported by RSA keys.")
public class DecryptRequestDto {
    @NotEmpty
    @Base64Encoded
    @Schema(description="Encrypted payload (base64 encoded) that shall be decrypted.", format="byte")
    private String encryptedPayload;
    @NotEmpty
    @Schema(description="Name of the key with which the payload shall be decrypted.")
    private String decryptKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the decrypt key."), schema=@Schema(pattern="^.{1}$"))
    private char[] keyPassword;
    @Base64Encoded
    @Schema(description="Additional meta data that will be provided to the approval client", format="base64")
    private String metaData;
    @Base64Encoded
    @Schema(description="Signature for the meta data.", format="base64")
    private String metaDataSignature;
    @NotNull
    @Schema(description="The cipher algorithm to be used.")
    private CipherAlgorithm cipherAlgorithm;
    @Schema(description="The initialization vector (base64 encoded) used to encrypt the payload. Can be empty if the cipher algorithm used does not require an initialization vector.")
    private String initializationVector;
    @Base64Encoded
    @Schema(description="Additional authentication data (aad, base64) used when decrypting payload. Can be empty if none were used when encrypting the payload", format="base64")
    private String additionalAuthenticationData;
    @Schema(description="The MAC (Message Authentication Tag) is a fixed-length value that is INCLUDED in the ciphertext and used to authenticatethe integrity of the data and the authenticity of the sender. Supported tag_length: 0, 64, 96, 104, 112, 120, 128", format="int")
    private int tagLength = 0;

    public String getEncryptedPayload() {
        return this.encryptedPayload;
    }

    public String getDecryptKeyName() {
        return this.decryptKeyName;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String getMetaDataSignature() {
        return this.metaDataSignature;
    }

    public CipherAlgorithm getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public String getInitializationVector() {
        return this.initializationVector;
    }

    public String getAdditionalAuthenticationData() {
        return this.additionalAuthenticationData;
    }

    public int getTagLength() {
        return this.tagLength;
    }

    public void setEncryptedPayload(String encryptedPayload) {
        this.encryptedPayload = encryptedPayload;
    }

    public void setDecryptKeyName(String decryptKeyName) {
        this.decryptKeyName = decryptKeyName;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    public void setMetaDataSignature(String metaDataSignature) {
        this.metaDataSignature = metaDataSignature;
    }

    public void setCipherAlgorithm(CipherAlgorithm cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public void setInitializationVector(String initializationVector) {
        this.initializationVector = initializationVector;
    }

    public void setAdditionalAuthenticationData(String additionalAuthenticationData) {
        this.additionalAuthenticationData = additionalAuthenticationData;
    }

    public void setTagLength(int tagLength) {
        this.tagLength = tagLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecryptRequestDto)) {
            return false;
        }
        DecryptRequestDto other = (DecryptRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTagLength() != other.getTagLength()) {
            return false;
        }
        String this$encryptedPayload = this.getEncryptedPayload();
        String other$encryptedPayload = other.getEncryptedPayload();
        if (this$encryptedPayload == null ? other$encryptedPayload != null : !this$encryptedPayload.equals(other$encryptedPayload)) {
            return false;
        }
        String this$decryptKeyName = this.getDecryptKeyName();
        String other$decryptKeyName = other.getDecryptKeyName();
        if (this$decryptKeyName == null ? other$decryptKeyName != null : !this$decryptKeyName.equals(other$decryptKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyPassword(), other.getKeyPassword())) {
            return false;
        }
        String this$metaData = this.getMetaData();
        String other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData)) {
            return false;
        }
        String this$metaDataSignature = this.getMetaDataSignature();
        String other$metaDataSignature = other.getMetaDataSignature();
        if (this$metaDataSignature == null ? other$metaDataSignature != null : !this$metaDataSignature.equals(other$metaDataSignature)) {
            return false;
        }
        CipherAlgorithm this$cipherAlgorithm = this.getCipherAlgorithm();
        CipherAlgorithm other$cipherAlgorithm = other.getCipherAlgorithm();
        if (this$cipherAlgorithm == null ? other$cipherAlgorithm != null : !((Object)((Object)this$cipherAlgorithm)).equals((Object)other$cipherAlgorithm)) {
            return false;
        }
        String this$initializationVector = this.getInitializationVector();
        String other$initializationVector = other.getInitializationVector();
        if (this$initializationVector == null ? other$initializationVector != null : !this$initializationVector.equals(other$initializationVector)) {
            return false;
        }
        String this$additionalAuthenticationData = this.getAdditionalAuthenticationData();
        String other$additionalAuthenticationData = other.getAdditionalAuthenticationData();
        return !(this$additionalAuthenticationData == null ? other$additionalAuthenticationData != null : !this$additionalAuthenticationData.equals(other$additionalAuthenticationData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DecryptRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTagLength();
        String $encryptedPayload = this.getEncryptedPayload();
        result = result * 59 + ($encryptedPayload == null ? 43 : $encryptedPayload.hashCode());
        String $decryptKeyName = this.getDecryptKeyName();
        result = result * 59 + ($decryptKeyName == null ? 43 : $decryptKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        String $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
        String $metaDataSignature = this.getMetaDataSignature();
        result = result * 59 + ($metaDataSignature == null ? 43 : $metaDataSignature.hashCode());
        CipherAlgorithm $cipherAlgorithm = this.getCipherAlgorithm();
        result = result * 59 + ($cipherAlgorithm == null ? 43 : ((Object)((Object)$cipherAlgorithm)).hashCode());
        String $initializationVector = this.getInitializationVector();
        result = result * 59 + ($initializationVector == null ? 43 : $initializationVector.hashCode());
        String $additionalAuthenticationData = this.getAdditionalAuthenticationData();
        result = result * 59 + ($additionalAuthenticationData == null ? 43 : $additionalAuthenticationData.hashCode());
        return result;
    }

    public String toString() {
        return "DecryptRequestDto(encryptedPayload=" + this.getEncryptedPayload() + ", decryptKeyName=" + this.getDecryptKeyName() + ", keyPassword=" + Arrays.toString(this.getKeyPassword()) + ", metaData=" + this.getMetaData() + ", metaDataSignature=" + this.getMetaDataSignature() + ", cipherAlgorithm=" + this.getCipherAlgorithm() + ", initializationVector=" + this.getInitializationVector() + ", additionalAuthenticationData=" + this.getAdditionalAuthenticationData() + ", tagLength=" + this.getTagLength() + ")";
    }
}

