/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

@Schema(description="Derive key request.")
public class DeriveKeyDto {
    @NotEmpty
    @Schema(description="The name of the master key.")
    private String masterKeyLabel;
    @ArraySchema(arraySchema=@Schema(description="The password of the master key, if the master key has a password set."), schema=@Schema(pattern="^.{1}$"))
    private char[] masterKeyPassword;
    @NotEmpty
    @Schema(description="BIP32 derivation path to be used (without leading /)", example="1/2/3")
    private String derivationPath;
    private Attributes attributes;

    public String getMasterKeyLabel() {
        return this.masterKeyLabel;
    }

    public char[] getMasterKeyPassword() {
        return this.masterKeyPassword;
    }

    public String getDerivationPath() {
        return this.derivationPath;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setMasterKeyLabel(String masterKeyLabel) {
        this.masterKeyLabel = masterKeyLabel;
    }

    public void setMasterKeyPassword(char[] masterKeyPassword) {
        this.masterKeyPassword = masterKeyPassword;
    }

    public void setDerivationPath(String derivationPath) {
        this.derivationPath = derivationPath;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeriveKeyDto)) {
            return false;
        }
        DeriveKeyDto other = (DeriveKeyDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$masterKeyLabel = this.getMasterKeyLabel();
        String other$masterKeyLabel = other.getMasterKeyLabel();
        if (this$masterKeyLabel == null ? other$masterKeyLabel != null : !this$masterKeyLabel.equals(other$masterKeyLabel)) {
            return false;
        }
        if (!Arrays.equals(this.getMasterKeyPassword(), other.getMasterKeyPassword())) {
            return false;
        }
        String this$derivationPath = this.getDerivationPath();
        String other$derivationPath = other.getDerivationPath();
        if (this$derivationPath == null ? other$derivationPath != null : !this$derivationPath.equals(other$derivationPath)) {
            return false;
        }
        Attributes this$attributes = this.getAttributes();
        Attributes other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeriveKeyDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $masterKeyLabel = this.getMasterKeyLabel();
        result = result * 59 + ($masterKeyLabel == null ? 43 : $masterKeyLabel.hashCode());
        result = result * 59 + Arrays.hashCode(this.getMasterKeyPassword());
        String $derivationPath = this.getDerivationPath();
        result = result * 59 + ($derivationPath == null ? 43 : $derivationPath.hashCode());
        Attributes $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "DeriveKeyDto(masterKeyLabel=" + this.getMasterKeyLabel() + ", masterKeyPassword=" + Arrays.toString(this.getMasterKeyPassword()) + ", derivationPath=" + this.getDerivationPath() + ", attributes=" + this.getAttributes() + ")";
    }

    @Schema(name="DeriveKeyAttributes", description="The attributes of the derived key. The attributes from the base key are fetched and applied if no attributes are specified.")
    public static class Attributes {
        @NotNull
        @Schema(description="If true the key can be used to decrypt data.")
        private Boolean decrypt;
        @NotNull
        @Schema(description="If true the key can sign.")
        private Boolean sign;
        @NotNull
        @Schema(description="If true the key can be used to unwrap keys.")
        private Boolean unwrap;
        @Schema(description="If true it is possible to derive from this key.", defaultValue="false")
        private boolean derive = false;
        @Schema(description="If true the key is extractable. This option can only be true for keys without smart key attributes.", defaultValue="false")
        private boolean extractable = false;
        @Schema(description="If true the key can be modified. The derived key can not be modifiable if the base key is not modifiable", defaultValue="true")
        private boolean modifiable = true;
        @Schema(description="If true the key can be deleted.", defaultValue="false")
        private boolean destroyable = false;
        @Schema(description="If true the key is sensitive. To export a key sensitive must be false")
        private Boolean sensitive;

        public Boolean getDecrypt() {
            return this.decrypt;
        }

        public Boolean getSign() {
            return this.sign;
        }

        public Boolean getUnwrap() {
            return this.unwrap;
        }

        public boolean isDerive() {
            return this.derive;
        }

        public boolean isExtractable() {
            return this.extractable;
        }

        public boolean isModifiable() {
            return this.modifiable;
        }

        public boolean isDestroyable() {
            return this.destroyable;
        }

        public Boolean getSensitive() {
            return this.sensitive;
        }

        public void setDecrypt(Boolean decrypt) {
            this.decrypt = decrypt;
        }

        public void setSign(Boolean sign) {
            this.sign = sign;
        }

        public void setUnwrap(Boolean unwrap) {
            this.unwrap = unwrap;
        }

        public void setDerive(boolean derive) {
            this.derive = derive;
        }

        public void setExtractable(boolean extractable) {
            this.extractable = extractable;
        }

        public void setModifiable(boolean modifiable) {
            this.modifiable = modifiable;
        }

        public void setDestroyable(boolean destroyable) {
            this.destroyable = destroyable;
        }

        public void setSensitive(Boolean sensitive) {
            this.sensitive = sensitive;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attributes)) {
                return false;
            }
            Attributes other = (Attributes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDerive() != other.isDerive()) {
                return false;
            }
            if (this.isExtractable() != other.isExtractable()) {
                return false;
            }
            if (this.isModifiable() != other.isModifiable()) {
                return false;
            }
            if (this.isDestroyable() != other.isDestroyable()) {
                return false;
            }
            Boolean this$decrypt = this.getDecrypt();
            Boolean other$decrypt = other.getDecrypt();
            if (this$decrypt == null ? other$decrypt != null : !((Object)this$decrypt).equals(other$decrypt)) {
                return false;
            }
            Boolean this$sign = this.getSign();
            Boolean other$sign = other.getSign();
            if (this$sign == null ? other$sign != null : !((Object)this$sign).equals(other$sign)) {
                return false;
            }
            Boolean this$unwrap = this.getUnwrap();
            Boolean other$unwrap = other.getUnwrap();
            if (this$unwrap == null ? other$unwrap != null : !((Object)this$unwrap).equals(other$unwrap)) {
                return false;
            }
            Boolean this$sensitive = this.getSensitive();
            Boolean other$sensitive = other.getSensitive();
            return !(this$sensitive == null ? other$sensitive != null : !((Object)this$sensitive).equals(other$sensitive));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Attributes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDerive() ? 79 : 97);
            result = result * 59 + (this.isExtractable() ? 79 : 97);
            result = result * 59 + (this.isModifiable() ? 79 : 97);
            result = result * 59 + (this.isDestroyable() ? 79 : 97);
            Boolean $decrypt = this.getDecrypt();
            result = result * 59 + ($decrypt == null ? 43 : ((Object)$decrypt).hashCode());
            Boolean $sign = this.getSign();
            result = result * 59 + ($sign == null ? 43 : ((Object)$sign).hashCode());
            Boolean $unwrap = this.getUnwrap();
            result = result * 59 + ($unwrap == null ? 43 : ((Object)$unwrap).hashCode());
            Boolean $sensitive = this.getSensitive();
            result = result * 59 + ($sensitive == null ? 43 : ((Object)$sensitive).hashCode());
            return result;
        }

        public String toString() {
            return "DeriveKeyDto.Attributes(decrypt=" + this.getDecrypt() + ", sign=" + this.getSign() + ", unwrap=" + this.getUnwrap() + ", derive=" + this.isDerive() + ", extractable=" + this.isExtractable() + ", modifiable=" + this.isModifiable() + ", destroyable=" + this.isDestroyable() + ", sensitive=" + this.getSensitive() + ")";
        }
    }
}

