/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;

@Schema(description="Metadata for enabling result paging")
public class PagingDto {
    @Min(value=0L)
    @Schema(description="The number of the page of results to be returned.")
    private @Min(value=0L) int pageNumber;
    @Min(value=1L)
    @Schema(description="The number of results to be returned per page")
    private @Min(value=1L) int pageSize;
    @NotNull
    @Schema(description="Sort order of the results. Note: initial value for LAST_FETCHED_DATE is the creation date of the task. LAST_FETCHED_DATE is updated every time a task is returned to the client using the appropriate REST service.")
    private SortOrder sortOrder;

    public PagingDto() {
    }

    public PagingDto(int pageNumber, int pageSize, SortOrder sortOrder) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.sortOrder = sortOrder;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public static enum SortOrder {
        CREATION_DATE_ASC,
        CREATION_DATE_DESC,
        LAST_FETCHED_DATE_ASC,
        LAST_FETCHED_DATE_DESC;

    }
}

