/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.dto.tsb.request;

import com.securosys.tee.dto.tsb.request.AttributesDto;
import com.securosys.tee.enums.tsb.WrapMethod;
import com.securosys.tee.validation.tsb.Base64Encoded;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

@Schema(description="Unwrap key request.")
public class UnwrapKeyRequestDto {
    @NotEmpty
    @Base64Encoded
    @Schema(description="The key (base64 encoded) that shall be unwrapped", format="base64")
    private String wrappedKey;
    @NotEmpty
    @Schema(description="The name of the key with which the unwrapped key shall be saved on the HSM")
    private String label;
    @NotNull
    @Valid
    private AttributesDto attributes;
    @NotEmpty
    @Schema(description="Name of the key with which the key shall be unwrapped.")
    private String unwrapKeyName;
    @ArraySchema(arraySchema=@Schema(description="Password of the unwrap key."), schema=@Schema(pattern="^.{1}$"))
    private char[] unwrapKeyPassword;
    @Base64Encoded
    @Schema(description="Additional meta data that will be provided to the approval client", format="base64")
    private String metaData;
    @Base64Encoded
    @Schema(description="Signature for the meta data.", format="base64")
    private String metaDataSignature;
    @NotNull
    @Schema(description="The wrap method to be used. The chosen method has to be compatible with the types of the referenced keys")
    private WrapMethod wrapMethod;

    public String getWrappedKey() {
        return this.wrappedKey;
    }

    public String getLabel() {
        return this.label;
    }

    public AttributesDto getAttributes() {
        return this.attributes;
    }

    public String getUnwrapKeyName() {
        return this.unwrapKeyName;
    }

    public char[] getUnwrapKeyPassword() {
        return this.unwrapKeyPassword;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String getMetaDataSignature() {
        return this.metaDataSignature;
    }

    public WrapMethod getWrapMethod() {
        return this.wrapMethod;
    }

    public void setWrappedKey(String wrappedKey) {
        this.wrappedKey = wrappedKey;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAttributes(AttributesDto attributes) {
        this.attributes = attributes;
    }

    public void setUnwrapKeyName(String unwrapKeyName) {
        this.unwrapKeyName = unwrapKeyName;
    }

    public void setUnwrapKeyPassword(char[] unwrapKeyPassword) {
        this.unwrapKeyPassword = unwrapKeyPassword;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    public void setMetaDataSignature(String metaDataSignature) {
        this.metaDataSignature = metaDataSignature;
    }

    public void setWrapMethod(WrapMethod wrapMethod) {
        this.wrapMethod = wrapMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnwrapKeyRequestDto)) {
            return false;
        }
        UnwrapKeyRequestDto other = (UnwrapKeyRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$wrappedKey = this.getWrappedKey();
        String other$wrappedKey = other.getWrappedKey();
        if (this$wrappedKey == null ? other$wrappedKey != null : !this$wrappedKey.equals(other$wrappedKey)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        AttributesDto this$attributes = this.getAttributes();
        AttributesDto other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$unwrapKeyName = this.getUnwrapKeyName();
        String other$unwrapKeyName = other.getUnwrapKeyName();
        if (this$unwrapKeyName == null ? other$unwrapKeyName != null : !this$unwrapKeyName.equals(other$unwrapKeyName)) {
            return false;
        }
        if (!Arrays.equals(this.getUnwrapKeyPassword(), other.getUnwrapKeyPassword())) {
            return false;
        }
        String this$metaData = this.getMetaData();
        String other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData)) {
            return false;
        }
        String this$metaDataSignature = this.getMetaDataSignature();
        String other$metaDataSignature = other.getMetaDataSignature();
        if (this$metaDataSignature == null ? other$metaDataSignature != null : !this$metaDataSignature.equals(other$metaDataSignature)) {
            return false;
        }
        WrapMethod this$wrapMethod = this.getWrapMethod();
        WrapMethod other$wrapMethod = other.getWrapMethod();
        return !(this$wrapMethod == null ? other$wrapMethod != null : !((Object)((Object)this$wrapMethod)).equals((Object)other$wrapMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnwrapKeyRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $wrappedKey = this.getWrappedKey();
        result = result * 59 + ($wrappedKey == null ? 43 : $wrappedKey.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        AttributesDto $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $unwrapKeyName = this.getUnwrapKeyName();
        result = result * 59 + ($unwrapKeyName == null ? 43 : $unwrapKeyName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getUnwrapKeyPassword());
        String $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
        String $metaDataSignature = this.getMetaDataSignature();
        result = result * 59 + ($metaDataSignature == null ? 43 : $metaDataSignature.hashCode());
        WrapMethod $wrapMethod = this.getWrapMethod();
        result = result * 59 + ($wrapMethod == null ? 43 : ((Object)((Object)$wrapMethod)).hashCode());
        return result;
    }

    public String toString() {
        return "UnwrapKeyRequestDto(wrappedKey=" + this.getWrappedKey() + ", label=" + this.getLabel() + ", attributes=" + this.getAttributes() + ", unwrapKeyName=" + this.getUnwrapKeyName() + ", unwrapKeyPassword=" + Arrays.toString(this.getUnwrapKeyPassword()) + ", metaData=" + this.getMetaData() + ", metaDataSignature=" + this.getMetaDataSignature() + ", wrapMethod=" + this.getWrapMethod() + ")";
    }
}

