/*
 * Decompiled with CFR 0.152.
 */
package com.securosys.tee.validation.tsb;

import com.securosys.tee.validation.tsb.Base64Encoded;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

public class Base64EncodedValidator
implements ConstraintValidator<Base64Encoded, String> {
    private static final Pattern pattern = Pattern.compile("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");

    private static String sanitizeOpenSsl(String value) {
        return value.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
    }

    @Override
    public void initialize(Base64Encoded constraintAnnotation) {
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        String openSslSanitizedValue = Base64EncodedValidator.sanitizeOpenSsl(value);
        return pattern.matcher(openSslSanitizedValue).matches();
    }
}

